package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0014;
import cn.ibizlab.core.sample.filter.IBIZSample0014SearchContext;
import cn.ibizlab.core.sample.service.IIBIZSample0014Service;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZSample0014Mapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[员工] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0014ServiceImpl")
public class IBIZSample0014ServiceImpl extends ServiceImpl<IBIZSample0014Mapper, IBIZSample0014> implements IIBIZSample0014Service {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZSample0016Service ibizsample0016Service;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZSample0003Service ibizsample0003Service;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZSample0014 et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0014id()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZSample0014> list) {
        list.forEach(item->fillParentData(item));
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZSample0014 et) {
        fillParentData(et);
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizsample0014id", et.getIbizsample0014id()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0014id()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZSample0014> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        ibizsample0016Service.resetByIbizsample0014id(key);
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        ibizsample0016Service.resetByIbizsample0014id(idList);
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZSample0014 get(String key) {
        IBIZSample0014 et = getById(key);
        if(et == null){
            et = new IBIZSample0014();
            et.setIbizsample0014id(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZSample0014 getDraft(IBIZSample0014 et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(IBIZSample0014 et) {
        return (!ObjectUtils.isEmpty(et.getIbizsample0014id())) && (!Objects.isNull(this.getById(et.getIbizsample0014id())));
    }
    @Override
    @Transactional
    public boolean save(IBIZSample0014 et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZSample0014 et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZSample0014> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZSample0014> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<IBIZSample0014> selectByIbizsample0003id(String ibizsample0003id) {
        return baseMapper.selectByIbizsample0003id(ibizsample0003id);
    }
    @Override
    public void removeByIbizsample0003id(String ibizsample0003id) {
        this.remove(new QueryWrapper<IBIZSample0014>().eq("ibizsample0003id",ibizsample0003id));
    }


    /**
     * 查询集合 CurIBIZSample0014
     */
    @Override
    public Page<IBIZSample0014> searchCurIBIZSample0014(IBIZSample0014SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0014> pages=baseMapper.searchCurIBIZSample0014(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0014>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }

    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZSample0014> searchDefault(IBIZSample0014SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0014> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0014>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(IBIZSample0014 et){
        //实体关系[DER1N_IBIZSAMPLE0014_IBIZSAMPLE0003_IBIZSAMPLE0003ID]
        if(!ObjectUtils.isEmpty(et.getIbizsample0003id())){
            cn.ibizlab.core.sample.domain.IBIZSample0003 ibizsample0003=et.getIbizsample0003();
            if(ObjectUtils.isEmpty(ibizsample0003)){
                cn.ibizlab.core.sample.domain.IBIZSample0003 majorEntity=ibizsample0003Service.get(et.getIbizsample0003id());
                et.setIbizsample0003(majorEntity);
                ibizsample0003=majorEntity;
            }
            et.setIbizsample0003name(ibizsample0003.getIbizsample0003name());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZSample0014> getIbizsample0014ByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZSample0014> getIbizsample0014ByEntities(List<IBIZSample0014> entities) {
        List ids =new ArrayList();
        for(IBIZSample0014 entity : entities){
            Serializable id=entity.getIbizsample0014id();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



