package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0011;
import cn.ibizlab.core.sample.filter.IBIZSample0011SearchContext;
import cn.ibizlab.core.sample.service.IIBIZSample0011Service;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZSample0011Mapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[订单明细] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0011ServiceImpl")
public class IBIZSample0011ServiceImpl extends ServiceImpl<IBIZSample0011Mapper, IBIZSample0011> implements IIBIZSample0011Service {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZSample0010Service ibizsample0010Service;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZUNIProductService ibizuniproductService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZSample0011 et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0011id()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZSample0011> list) {
        list.forEach(item->fillParentData(item));
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZSample0011 et) {
        fillParentData(et);
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizsample0011id", et.getIbizsample0011id()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0011id()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZSample0011> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZSample0011 get(String key) {
        IBIZSample0011 et = getById(key);
        if(et == null){
            et = new IBIZSample0011();
            et.setIbizsample0011id(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZSample0011 getDraft(IBIZSample0011 et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(IBIZSample0011 et) {
        return (!ObjectUtils.isEmpty(et.getIbizsample0011id())) && (!Objects.isNull(this.getById(et.getIbizsample0011id())));
    }
    @Override
    @Transactional
    public boolean save(IBIZSample0011 et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZSample0011 et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZSample0011> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZSample0011> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<IBIZSample0011> selectByIbizsample0010id(String ibizsample0010id) {
        return baseMapper.selectByIbizsample0010id(ibizsample0010id);
    }
    @Override
    public void removeByIbizsample0010id(Collection<String> ids) {
        this.remove(new QueryWrapper<IBIZSample0011>().in("ibizsample0010id",ids));
    }

    @Override
    public void removeByIbizsample0010id(String ibizsample0010id) {
        this.remove(new QueryWrapper<IBIZSample0011>().eq("ibizsample0010id",ibizsample0010id));
    }

	@Override
    public List<IBIZSample0011> selectByIbizuniproductid(String ibizuniproductid) {
        return baseMapper.selectByIbizuniproductid(ibizuniproductid);
    }
    @Override
    public void removeByIbizuniproductid(String ibizuniproductid) {
        this.remove(new QueryWrapper<IBIZSample0011>().eq("ibizuniproductid",ibizuniproductid));
    }


    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZSample0011> searchDefault(IBIZSample0011SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0011> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0011>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(IBIZSample0011 et){
        //实体关系[DER1N_IBIZSAMPLE0011_IBIZSAMPLE0010_IBIZSAMPLE0010ID]
        if(!ObjectUtils.isEmpty(et.getIbizsample0010id())){
            cn.ibizlab.core.sample.domain.IBIZSample0010 ibizsample0010=et.getIbizsample0010();
            if(ObjectUtils.isEmpty(ibizsample0010)){
                cn.ibizlab.core.sample.domain.IBIZSample0010 majorEntity=ibizsample0010Service.get(et.getIbizsample0010id());
                et.setIbizsample0010(majorEntity);
                ibizsample0010=majorEntity;
            }
            et.setIbizsample0010name(ibizsample0010.getIbizsample0010name());
        }
        //实体关系[DER1N_IBIZSAMPLE0011_IBIZUNIPRODUCT_IBIZUNIPRODUCTID]
        if(!ObjectUtils.isEmpty(et.getIbizuniproductid())){
            cn.ibizlab.core.sample.domain.IBIZUNIProduct ibizuniproduct=et.getIbizuniproduct();
            if(ObjectUtils.isEmpty(ibizuniproduct)){
                cn.ibizlab.core.sample.domain.IBIZUNIProduct majorEntity=ibizuniproductService.get(et.getIbizuniproductid());
                et.setIbizuniproduct(majorEntity);
                ibizuniproduct=majorEntity;
            }
            et.setIbizuniproductname(ibizuniproduct.getIbizuniproductname());
            et.setUnitprice(ibizuniproduct.getUnitprice());
            et.setUnit(ibizuniproduct.getUnit());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZSample0011> getIbizsample0011ByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZSample0011> getIbizsample0011ByEntities(List<IBIZSample0011> entities) {
        List ids =new ArrayList();
        for(IBIZSample0011 entity : entities){
            Serializable id=entity.getIbizsample0011id();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



