package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0008;
import cn.ibizlab.core.sample.filter.IBIZSample0008SearchContext;
import cn.ibizlab.core.sample.service.IIBIZSample0008Service;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZSample0008Mapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[自循环流程] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0008ServiceImpl")
public class IBIZSample0008ServiceImpl extends ServiceImpl<IBIZSample0008Mapper, IBIZSample0008> implements IIBIZSample0008Service {


    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZSample0008 et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0008id()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZSample0008> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZSample0008 et) {
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizsample0008id", et.getIbizsample0008id()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0008id()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZSample0008> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZSample0008 get(String key) {
        IBIZSample0008 et = getById(key);
        if(et == null){
            et = new IBIZSample0008();
            et.setIbizsample0008id(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZSample0008 getDraft(IBIZSample0008 et) {
        return et;
    }

    @Override
    public boolean checkKey(IBIZSample0008 et) {
        return (!ObjectUtils.isEmpty(et.getIbizsample0008id())) && (!Objects.isNull(this.getById(et.getIbizsample0008id())));
    }
    @Override
    @Transactional
    public boolean save(IBIZSample0008 et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZSample0008 et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZSample0008> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZSample0008> list) {
        saveOrUpdateBatch(list,batchSize);
    }



    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZSample0008> searchDefault(IBIZSample0008SearchContext context) {
        fillWFTaskContext(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0008> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0008>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }


    @Autowired
    private cn.ibizlab.util.client.IBZWFFeignClient ibzwfFeignClient;

    /**
     * 查询工作流待办
     * @param context
     */
    private void fillWFTaskContext(IBIZSample0008SearchContext context){

        if(!StringUtils.isEmpty(context.getUserTaskId()) && !StringUtils.isEmpty(context.getProcessDefinitionKey())){
            List<String> businessKeys= ibzwfFeignClient.getbusinesskeysByUserId("demosys", cn.ibizlab.util.security.AuthenticationUser.getAuthenticationUser().getUserid(),"ibizsample0008s",context.getProcessDefinitionKey(),context.getUserTaskId());
            if(businessKeys.size()>0){
                context.getSelectCond().in("ibizsample0008id",businessKeys);
            }
            else{
                context.getSelectCond().apply("1<>1");
            }
        }
    }





    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZSample0008> getIbizsample0008ByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZSample0008> getIbizsample0008ByEntities(List<IBIZSample0008> entities) {
        List ids =new ArrayList();
        for(IBIZSample0008 entity : entities){
            Serializable id=entity.getIbizsample0008id();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



