package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZOrderType;
import cn.ibizlab.core.sample.filter.IBIZOrderTypeSearchContext;
import cn.ibizlab.core.sample.service.IIBIZOrderTypeService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZOrderTypeMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[订单类型] 服务对象接口实现
 */
@Slf4j
@Service("IBIZOrderTypeServiceImpl")
public class IBIZOrderTypeServiceImpl extends ServiceImpl<IBIZOrderTypeMapper, IBIZOrderType> implements IIBIZOrderTypeService {


    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZOrderType et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizordertypeid()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZOrderType> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZOrderType et) {
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizordertypeid", et.getIbizordertypeid()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizordertypeid()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZOrderType> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZOrderType get(String key) {
        IBIZOrderType et = getById(key);
        if(et == null){
            et = new IBIZOrderType();
            et.setIbizordertypeid(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZOrderType getDraft(IBIZOrderType et) {
        return et;
    }

    @Override
    public boolean checkKey(IBIZOrderType et) {
        return (!ObjectUtils.isEmpty(et.getIbizordertypeid())) && (!Objects.isNull(this.getById(et.getIbizordertypeid())));
    }
    @Override
    @Transactional
    public IBIZOrderType resetCodeList(IBIZOrderType et) {
        //自定义代码
        return et;
    }

    @Override
    @Transactional
    public boolean save(IBIZOrderType et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZOrderType et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZOrderType> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZOrderType> list) {
        saveOrUpdateBatch(list,batchSize);
    }



    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZOrderType> searchDefault(IBIZOrderTypeSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZOrderType> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZOrderType>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }







    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZOrderType> getIbizordertypeByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZOrderType> getIbizordertypeByEntities(List<IBIZOrderType> entities) {
        List ids =new ArrayList();
        for(IBIZOrderType entity : entities){
            Serializable id=entity.getIbizordertypeid();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



