package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZCustomer_INTF;
import cn.ibizlab.core.sample.filter.IBIZCustomer_INTFSearchContext;
import cn.ibizlab.core.sample.service.IIBIZCustomer_INTFService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZCustomer_INTFMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[客户] 服务对象接口实现
 */
@Slf4j
@Service("IBIZCustomer_INTFServiceImpl")
public class IBIZCustomer_INTFServiceImpl extends ServiceImpl<IBIZCustomer_INTFMapper, IBIZCustomer_INTF> implements IIBIZCustomer_INTFService {


    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZCustomer_INTF et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizcustomerid()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZCustomer_INTF> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZCustomer_INTF et) {
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizcustomerid", et.getIbizcustomerid()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizcustomerid()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZCustomer_INTF> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZCustomer_INTF get(String key) {
        IBIZCustomer_INTF et = getById(key);
        if(et == null){
            et = new IBIZCustomer_INTF();
            et.setIbizcustomerid(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZCustomer_INTF getDraft(IBIZCustomer_INTF et) {
        return et;
    }

    @Override
    public boolean checkKey(IBIZCustomer_INTF et) {
        return (!ObjectUtils.isEmpty(et.getIbizcustomerid())) && (!Objects.isNull(this.getById(et.getIbizcustomerid())));
    }
    @Override
    @Transactional
    public boolean save(IBIZCustomer_INTF et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZCustomer_INTF et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZCustomer_INTF> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZCustomer_INTF> list) {
        saveOrUpdateBatch(list,batchSize);
    }

    @Override
    @Transactional
    public IBIZCustomer_INTF xXX(IBIZCustomer_INTF et) {
        //自定义代码
        return et;
    }



    /**
     * 查询集合 CurCustomer
     */
    @Override
    public Page<IBIZCustomer_INTF> searchCurCustomer(IBIZCustomer_INTFSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZCustomer_INTF> pages=baseMapper.searchCurCustomer(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZCustomer_INTF>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }

    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZCustomer_INTF> searchDefault(IBIZCustomer_INTFSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZCustomer_INTF> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZCustomer_INTF>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }







    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZCustomer_INTF> getIbizcustomerIntfByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZCustomer_INTF> getIbizcustomerIntfByEntities(List<IBIZCustomer_INTF> entities) {
        List ids =new ArrayList();
        for(IBIZCustomer_INTF entity : entities){
            Serializable id=entity.getIbizcustomerid();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



