package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.Appkanban;
import cn.ibizlab.core.sample.filter.AppkanbanSearchContext;
import cn.ibizlab.core.sample.service.IAppkanbanService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.AppkanbanMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[应用视图信息] 服务对象接口实现
 */
@Slf4j
@Service("AppkanbanServiceImpl")
public class AppkanbanServiceImpl extends ServiceImpl<AppkanbanMapper, Appkanban> implements IAppkanbanService {


    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(Appkanban et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getAppkanbanid()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<Appkanban> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(Appkanban et) {
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("appkanbanid", et.getAppkanbanid()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getAppkanbanid()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<Appkanban> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public Appkanban get(String key) {
        Appkanban et = getById(key);
        if(et == null){
            et = new Appkanban();
            et.setAppkanbanid(key);
        }
        else {
        }
        return et;
    }

    @Override
    public Appkanban getDraft(Appkanban et) {
        return et;
    }

    @Override
    public boolean checkKey(Appkanban et) {
        return (!ObjectUtils.isEmpty(et.getAppkanbanid())) && (!Objects.isNull(this.getById(et.getAppkanbanid())));
    }
    @Override
    @Transactional
    public boolean save(Appkanban et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(Appkanban et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<Appkanban> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<Appkanban> list) {
        saveOrUpdateBatch(list,batchSize);
    }



    /**
     * 查询集合 数据集
     */
    @Override
    public Page<Appkanban> searchDefault(AppkanbanSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Appkanban> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<Appkanban>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }







    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<Appkanban> getAppkanbanByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<Appkanban> getAppkanbanByEntities(List<Appkanban> entities) {
        List ids =new ArrayList();
        for(Appkanban entity : entities){
            Serializable id=entity.getAppkanbanid();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



