package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZVIEWMESS;
import cn.ibizlab.core.sample.filter.IBIZVIEWMESSSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZVIEWMESS] 服务对象接口
 */
public interface IIBIZVIEWMESSService extends IService<IBIZVIEWMESS> {

    boolean create(IBIZVIEWMESS et);
    void createBatch(List<IBIZVIEWMESS> list);
    boolean update(IBIZVIEWMESS et);
    void updateBatch(List<IBIZVIEWMESS> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZVIEWMESS get(String key);
    IBIZVIEWMESS getDraft(IBIZVIEWMESS et);
    boolean checkKey(IBIZVIEWMESS et);
    boolean save(IBIZVIEWMESS et);
    void saveBatch(List<IBIZVIEWMESS> list);
    Page<IBIZVIEWMESS> searchDefault(IBIZVIEWMESSSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZVIEWMESS> getIbizviewmessByIds(List<String> ids);
    List<IBIZVIEWMESS> getIbizviewmessByEntities(List<IBIZVIEWMESS> entities);
}


