package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSample0020;
import cn.ibizlab.core.sample.filter.IBIZSample0020SearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSample0020] 服务对象接口
 */
public interface IIBIZSample0020Service extends IService<IBIZSample0020> {

    boolean create(IBIZSample0020 et);
    void createBatch(List<IBIZSample0020> list);
    boolean update(IBIZSample0020 et);
    void updateBatch(List<IBIZSample0020> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSample0020 get(String key);
    IBIZSample0020 getDraft(IBIZSample0020 et);
    boolean checkKey(IBIZSample0020 et);
    boolean save(IBIZSample0020 et);
    void saveBatch(List<IBIZSample0020> list);
    Page<IBIZSample0020> searchDefault(IBIZSample0020SearchContext context);
    List<IBIZSample0020> selectByIbizsample0019id(String ibizsample0019id);
    void removeByIbizsample0019id(String ibizsample0019id);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSample0020> getIbizsample0020ByIds(List<String> ids);
    List<IBIZSample0020> getIbizsample0020ByEntities(List<IBIZSample0020> entities);
}


