package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSample0013;
import cn.ibizlab.core.sample.filter.IBIZSample0013SearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSample0013] 服务对象接口
 */
public interface IIBIZSample0013Service extends IService<IBIZSample0013> {

    boolean create(IBIZSample0013 et);
    void createBatch(List<IBIZSample0013> list);
    boolean update(IBIZSample0013 et);
    void updateBatch(List<IBIZSample0013> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSample0013 get(String key);
    IBIZSample0013 getDraft(IBIZSample0013 et);
    boolean checkKey(IBIZSample0013 et);
    boolean save(IBIZSample0013 et);
    void saveBatch(List<IBIZSample0013> list);
    Page<IBIZSample0013> searchDefault(IBIZSample0013SearchContext context);
    List<IBIZSample0013> selectByIbizsample0012id(String ibizsample0012id);
    void resetByIbizsample0012id(String ibizsample0012id);
    void resetByIbizsample0012id(Collection<String> ids);
    void removeByIbizsample0012id(String ibizsample0012id);
    List<IBIZSample0013> selectByIbizuniproductid(String ibizuniproductid);
    void removeByIbizuniproductid(String ibizuniproductid);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSample0013> getIbizsample0013ByIds(List<String> ids);
    List<IBIZSample0013> getIbizsample0013ByEntities(List<IBIZSample0013> entities);
}


