package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZOrderDetail;
import cn.ibizlab.core.sample.filter.IBIZOrderDetailSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZOrderDetail] 服务对象接口
 */
public interface IIBIZOrderDetailService extends IService<IBIZOrderDetail> {

    boolean create(IBIZOrderDetail et);
    void createBatch(List<IBIZOrderDetail> list);
    IBIZOrderDetail createTemp(IBIZOrderDetail et);
    IBIZOrderDetail createTempMajor(IBIZOrderDetail et);
    boolean update(IBIZOrderDetail et);
    void updateBatch(List<IBIZOrderDetail> list);
    IBIZOrderDetail updateTemp(IBIZOrderDetail et);
    IBIZOrderDetail updateTempMajor(IBIZOrderDetail et);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZOrderDetail removeTemp(IBIZOrderDetail et);
    IBIZOrderDetail removeTempMajor(IBIZOrderDetail et);
    IBIZOrderDetail get(String key);
    IBIZOrderDetail getTemp(IBIZOrderDetail et);
    IBIZOrderDetail getTempMajor(IBIZOrderDetail et);
    IBIZOrderDetail getDraft(IBIZOrderDetail et);
    IBIZOrderDetail getDraftTemp(IBIZOrderDetail et);
    IBIZOrderDetail getDraftTempMajor(IBIZOrderDetail et);
    boolean checkKey(IBIZOrderDetail et);
    IBIZOrderDetail countMoney(IBIZOrderDetail et);
    IBIZOrderDetail getUnitAndPrice(IBIZOrderDetail et);
    boolean save(IBIZOrderDetail et);
    void saveBatch(List<IBIZOrderDetail> list);
    Page<IBIZOrderDetail> searchCSMXDY(IBIZOrderDetailSearchContext context);
    Page<IBIZOrderDetail> searchDefault(IBIZOrderDetailSearchContext context);
    Page<IBIZOrderDetail> searchLOGIC_0007(IBIZOrderDetailSearchContext context);
    Page<IBIZOrderDetail> searchX(IBIZOrderDetailSearchContext context);
    List<IBIZOrderDetail> selectByIbizorderid(String ibizorderid);
    List<IBIZOrderDetail> selectByIbizorderid(Collection<String> ids);
    void removeByIbizorderid(String ibizorderid);
    List<IBIZOrderDetail> selectByIbizuniproductid(String ibizuniproductid);
    List<IBIZOrderDetail> selectByIbizuniproductid(Collection<String> ids);
    void removeByIbizuniproductid(String ibizuniproductid);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZOrderDetail> getIbizorderdetailByIds(List<String> ids);
    List<IBIZOrderDetail> getIbizorderdetailByEntities(List<IBIZOrderDetail> entities);
}


