package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZCustomer_INTF;
import cn.ibizlab.core.sample.filter.IBIZCustomer_INTFSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZCustomer_INTF] 服务对象接口
 */
public interface IIBIZCustomer_INTFService extends IService<IBIZCustomer_INTF> {

    boolean create(IBIZCustomer_INTF et);
    void createBatch(List<IBIZCustomer_INTF> list);
    boolean update(IBIZCustomer_INTF et);
    void updateBatch(List<IBIZCustomer_INTF> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZCustomer_INTF get(String key);
    IBIZCustomer_INTF getDraft(IBIZCustomer_INTF et);
    boolean checkKey(IBIZCustomer_INTF et);
    boolean save(IBIZCustomer_INTF et);
    void saveBatch(List<IBIZCustomer_INTF> list);
    IBIZCustomer_INTF xXX(IBIZCustomer_INTF et);
    Page<IBIZCustomer_INTF> searchCurCustomer(IBIZCustomer_INTFSearchContext context);
    Page<IBIZCustomer_INTF> searchDefault(IBIZCustomer_INTFSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZCustomer_INTF> getIbizcustomerIntfByIds(List<String> ids);
    List<IBIZCustomer_INTF> getIbizcustomerIntfByEntities(List<IBIZCustomer_INTF> entities);
}


