package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZCustomer;
import cn.ibizlab.core.sample.filter.IBIZCustomerSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZCustomer] 服务对象接口
 */
public interface IIBIZCustomerService extends IService<IBIZCustomer> {

    boolean create(IBIZCustomer et);
    void createBatch(List<IBIZCustomer> list);
    boolean update(IBIZCustomer et);
    void updateBatch(List<IBIZCustomer> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZCustomer get(String key);
    IBIZCustomer getDraft(IBIZCustomer et);
    boolean checkKey(IBIZCustomer et);
    boolean save(IBIZCustomer et);
    void saveBatch(List<IBIZCustomer> list);
    Page<IBIZCustomer> searchDefault(IBIZCustomerSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZCustomer> getIbizcustomerByIds(List<String> ids);
    List<IBIZCustomer> getIbizcustomerByEntities(List<IBIZCustomer> entities);
}


