package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZCPU;
import cn.ibizlab.core.sample.filter.IBIZCPUSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZCPU] 服务对象接口
 */
public interface IIBIZCPUService extends IService<IBIZCPU> {

    boolean create(IBIZCPU et);
    void createBatch(List<IBIZCPU> list);
    boolean update(IBIZCPU et);
    void updateBatch(List<IBIZCPU> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZCPU get(String key);
    IBIZCPU getDraft(IBIZCPU et);
    boolean checkKey(IBIZCPU et);
    boolean save(IBIZCPU et);
    void saveBatch(List<IBIZCPU> list);
    Page<IBIZCPU> searchDefault(IBIZCPUSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZCPU> getIbizcpuByIds(List<String> ids);
    List<IBIZCPU> getIbizcpuByEntities(List<IBIZCPU> entities);
}


