package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZAccount;
import cn.ibizlab.core.sample.filter.IBIZAccountSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZAccount] 服务对象接口
 */
public interface IIBIZAccountService extends IService<IBIZAccount> {

    boolean create(IBIZAccount et);
    void createBatch(List<IBIZAccount> list);
    boolean update(IBIZAccount et);
    void updateBatch(List<IBIZAccount> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZAccount get(String key);
    IBIZAccount getDraft(IBIZAccount et);
    boolean checkKey(IBIZAccount et);
    boolean save(IBIZAccount et);
    void saveBatch(List<IBIZAccount> list);
    Page<IBIZAccount> searchDefault(IBIZAccountSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZAccount> getIbizaccountByIds(List<String> ids);
    List<IBIZAccount> getIbizaccountByEntities(List<IBIZAccount> entities);
}


