

package cn.ibizlab.core.sample.mapping;

import org.mapstruct.*;
import cn.ibizlab.core.sample.domain.IBIZCPU;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import java.util.List;

@Mapper(componentModel = "spring", uses = {})
public interface IBIZCPUInheritMapping {

    @Mappings({
        @Mapping(source ="ibizcpuid",target = "ibizhardwareid"),
        @Mapping(source ="ibizcpuname",target = "ibizhardwarename"),
        @Mapping(target ="focusNull",ignore = true),
    })
    IBIZHardware toIbizhardware(IBIZCPU ibizcpu);

    @Mappings({
        @Mapping(source ="ibizhardwareid" ,target = "ibizcpuid"),
        @Mapping(source ="ibizhardwarename" ,target = "ibizcpuname"),
        @Mapping(target ="focusNull",ignore = true),
    })
    IBIZCPU toIbizcpu(IBIZHardware ibizhardware);

    List<IBIZHardware> toIbizhardware(List<IBIZCPU> ibizcpu);

    List<IBIZCPU> toIbizcpu(List<IBIZHardware> ibizhardware);

}


