package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZViewMsg;
/**
 * 关系型数据实体[IBIZViewMsg] 查询条件对象
 */
@Slf4j
@Data
public class IBIZViewMsgSearchContext extends QueryWrapperContext<IBIZViewMsg> {

	private String n_ibizviewmsgname_like;//[视图消息源名称]
	public void setN_ibizviewmsgname_like(String n_ibizviewmsgname_like) {
        this.n_ibizviewmsgname_like = n_ibizviewmsgname_like;
        if(!ObjectUtils.isEmpty(this.n_ibizviewmsgname_like)){
            this.getSearchCond().like("ibizviewmsgname", n_ibizviewmsgname_like);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizviewmsgname", query)
            );
		 }
	}
}



