package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0014;
/**
 * 关系型数据实体[IBIZSample0014] 查询条件对象
 */
@Slf4j
@Data
public class IBIZSample0014SearchContext extends QueryWrapperContext<IBIZSample0014> {

	private String n_ibizsample0014name_like;//[员工名称]
	public void setN_ibizsample0014name_like(String n_ibizsample0014name_like) {
        this.n_ibizsample0014name_like = n_ibizsample0014name_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0014name_like)){
            this.getSearchCond().like("ibizsample0014name", n_ibizsample0014name_like);
        }
    }
	private String n_ibizsample0003name_eq;//[名称]
	public void setN_ibizsample0003name_eq(String n_ibizsample0003name_eq) {
        this.n_ibizsample0003name_eq = n_ibizsample0003name_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0003name_eq)){
            this.getSearchCond().eq("ibizsample0003name", n_ibizsample0003name_eq);
        }
    }
	private String n_ibizsample0003name_like;//[名称]
	public void setN_ibizsample0003name_like(String n_ibizsample0003name_like) {
        this.n_ibizsample0003name_like = n_ibizsample0003name_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0003name_like)){
            this.getSearchCond().like("ibizsample0003name", n_ibizsample0003name_like);
        }
    }
	private String n_ibizsample0003id_eq;//[IBIZSAMPLE0003标识]
	public void setN_ibizsample0003id_eq(String n_ibizsample0003id_eq) {
        this.n_ibizsample0003id_eq = n_ibizsample0003id_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0003id_eq)){
            this.getSearchCond().eq("ibizsample0003id", n_ibizsample0003id_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0014name", query)
            );
		 }
	}
}



