package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0011;
/**
 * 关系型数据实体[IBIZSample0011] 查询条件对象
 */
@Slf4j
@Data
public class IBIZSample0011SearchContext extends QueryWrapperContext<IBIZSample0011> {

	private String n_ibizsample0011name_like;//[订单明细名称]
	public void setN_ibizsample0011name_like(String n_ibizsample0011name_like) {
        this.n_ibizsample0011name_like = n_ibizsample0011name_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0011name_like)){
            this.getSearchCond().like("ibizsample0011name", n_ibizsample0011name_like);
        }
    }
	private String n_ibizsample0010name_eq;//[订单名称]
	public void setN_ibizsample0010name_eq(String n_ibizsample0010name_eq) {
        this.n_ibizsample0010name_eq = n_ibizsample0010name_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0010name_eq)){
            this.getSearchCond().eq("ibizsample0010name", n_ibizsample0010name_eq);
        }
    }
	private String n_ibizsample0010name_like;//[订单名称]
	public void setN_ibizsample0010name_like(String n_ibizsample0010name_like) {
        this.n_ibizsample0010name_like = n_ibizsample0010name_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0010name_like)){
            this.getSearchCond().like("ibizsample0010name", n_ibizsample0010name_like);
        }
    }
	private String n_ibizuniproductname_eq;//[统一产品名称]
	public void setN_ibizuniproductname_eq(String n_ibizuniproductname_eq) {
        this.n_ibizuniproductname_eq = n_ibizuniproductname_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizuniproductname_eq)){
            this.getSearchCond().eq("ibizuniproductname", n_ibizuniproductname_eq);
        }
    }
	private String n_ibizuniproductname_like;//[统一产品名称]
	public void setN_ibizuniproductname_like(String n_ibizuniproductname_like) {
        this.n_ibizuniproductname_like = n_ibizuniproductname_like;
        if(!ObjectUtils.isEmpty(this.n_ibizuniproductname_like)){
            this.getSearchCond().like("ibizuniproductname", n_ibizuniproductname_like);
        }
    }
	private String n_ibizsample0010id_eq;//[订单标识]
	public void setN_ibizsample0010id_eq(String n_ibizsample0010id_eq) {
        this.n_ibizsample0010id_eq = n_ibizsample0010id_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0010id_eq)){
            this.getSearchCond().eq("ibizsample0010id", n_ibizsample0010id_eq);
        }
    }
	private String n_ibizuniproductid_eq;//[统一产品标识]
	public void setN_ibizuniproductid_eq(String n_ibizuniproductid_eq) {
        this.n_ibizuniproductid_eq = n_ibizuniproductid_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizuniproductid_eq)){
            this.getSearchCond().eq("ibizuniproductid", n_ibizuniproductid_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0011name", query)
            );
		 }
	}
}



