package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0010;
/**
 * 关系型数据实体[IBIZSample0010] 查询条件对象
 */
@Slf4j
@Data
public class IBIZSample0010SearchContext extends QueryWrapperContext<IBIZSample0010> {

	private String n_ordertype_eq;//[订单类型]
	public void setN_ordertype_eq(String n_ordertype_eq) {
        this.n_ordertype_eq = n_ordertype_eq;
        if(!ObjectUtils.isEmpty(this.n_ordertype_eq)){
            this.getSearchCond().eq("ordertype", n_ordertype_eq);
        }
    }
	private String n_ibizsample0010name_like;//[订单名称]
	public void setN_ibizsample0010name_like(String n_ibizsample0010name_like) {
        this.n_ibizsample0010name_like = n_ibizsample0010name_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0010name_like)){
            this.getSearchCond().like("ibizsample0010name", n_ibizsample0010name_like);
        }
    }
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
	private Timestamp n_ordertime_gtandeq;//[订单时间]
	public void setN_ordertime_gtandeq(Timestamp n_ordertime_gtandeq) {
        this.n_ordertime_gtandeq = n_ordertime_gtandeq;
        if(!ObjectUtils.isEmpty(this.n_ordertime_gtandeq)){
            this.getSearchCond().ge("ordertime", n_ordertime_gtandeq);
        }
    }
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
	private Timestamp n_ordertime_ltandeq;//[订单时间]
	public void setN_ordertime_ltandeq(Timestamp n_ordertime_ltandeq) {
        this.n_ordertime_ltandeq = n_ordertime_ltandeq;
        if(!ObjectUtils.isEmpty(this.n_ordertime_ltandeq)){
            this.getSearchCond().le("ordertime", n_ordertime_ltandeq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0010name", query)
            );
		 }
	}
}



