package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0006;
/**
 * 关系型数据实体[IBIZSample0006] 查询条件对象
 */
@Slf4j
@Data
public class IBIZSample0006SearchContext extends QueryWrapperContext<IBIZSample0006> {

	private String n_ywstate_eq;//[业务状态]
	public void setN_ywstate_eq(String n_ywstate_eq) {
        this.n_ywstate_eq = n_ywstate_eq;
        if(!ObjectUtils.isEmpty(this.n_ywstate_eq)){
            this.getSearchCond().eq("ywstate", n_ywstate_eq);
        }
    }
	private String n_ibizsample0006name_like;//[公文名称]
	public void setN_ibizsample0006name_like(String n_ibizsample0006name_like) {
        this.n_ibizsample0006name_like = n_ibizsample0006name_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0006name_like)){
            this.getSearchCond().like("ibizsample0006name", n_ibizsample0006name_like);
        }
    }
	private String n_wfstep_eq;//[流程步骤]
	public void setN_wfstep_eq(String n_wfstep_eq) {
        this.n_wfstep_eq = n_wfstep_eq;
        if(!ObjectUtils.isEmpty(this.n_wfstep_eq)){
            this.getSearchCond().eq("wfstep", n_wfstep_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0006name", query)
            );
		 }
	}
}



