package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZQJ;
/**
 * 关系型数据实体[IBIZQJ] 查询条件对象
 */
@Slf4j
@Data
public class IBIZQJSearchContext extends QueryWrapperContext<IBIZQJ> {

	private String n_ibizqjname_like;//[请假名称]
	public void setN_ibizqjname_like(String n_ibizqjname_like) {
        this.n_ibizqjname_like = n_ibizqjname_like;
        if(!ObjectUtils.isEmpty(this.n_ibizqjname_like)){
            this.getSearchCond().like("ibizqjname", n_ibizqjname_like);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizqjname", query)
            );
		 }
	}
}



