package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZAccount;
/**
 * 关系型数据实体[IBIZAccount] 查询条件对象
 */
@Slf4j
@Data
public class IBIZAccountSearchContext extends QueryWrapperContext<IBIZAccount> {

	private String n_ibizaccountname_like;//[账户名称]
	public void setN_ibizaccountname_like(String n_ibizaccountname_like) {
        this.n_ibizaccountname_like = n_ibizaccountname_like;
        if(!ObjectUtils.isEmpty(this.n_ibizaccountname_like)){
            this.getSearchCond().like("ibizaccountname", n_ibizaccountname_like);
        }
    }
	private String n_ibizaccountid_eq;//[账户标识]
	public void setN_ibizaccountid_eq(String n_ibizaccountid_eq) {
        this.n_ibizaccountid_eq = n_ibizaccountid_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizaccountid_eq)){
            this.getSearchCond().eq("ibizaccountid", n_ibizaccountid_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizaccountname", query)
            );
		 }
	}
}



