package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZAPPVIEW;
/**
 * 关系型数据实体[IBIZAPPVIEW] 查询条件对象
 */
@Slf4j
@Data
public class IBIZAPPVIEWSearchContext extends QueryWrapperContext<IBIZAPPVIEW> {

	private String n_ibizappviewname_like;//[应用视图名称]
	public void setN_ibizappviewname_like(String n_ibizappviewname_like) {
        this.n_ibizappviewname_like = n_ibizappviewname_like;
        if(!ObjectUtils.isEmpty(this.n_ibizappviewname_like)){
            this.getSearchCond().like("ibizappviewname", n_ibizappviewname_like);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizappviewname", query)
            );
		 }
	}
}



