package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[视图数据信息实体]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZVIEWMESS", resultMap = "IBIZVIEWMESSResultMap")
public class IBIZVIEWMESS extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 视图数据信息实体名称
     */
    @TableField(value = "ibizviewmessname")
    @JSONField(name = "ibizviewmessname")
    @JsonProperty("ibizviewmessname")
    private String ibizviewmessname;
    /**
     * 视图数据信息实体标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizviewmessid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizviewmessid")
    @JsonProperty("ibizviewmessid")
    private String ibizviewmessid;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 文档地址
     */
    @TableField(value = "documentaddress")
    @JSONField(name = "documentaddress")
    @JsonProperty("documentaddress")
    private String documentaddress;
    /**
     * 视图实例地址
     */
    @TableField(value = "instanceaddress")
    @JSONField(name = "instanceaddress")
    @JsonProperty("instanceaddress")
    private String instanceaddress;
    /**
     * 视图类型
     */
    @TableField(value = "viewtype")
    @JSONField(name = "viewtype")
    @JsonProperty("viewtype")
    private String viewtype;
    /**
     * 视图描述
     */
    @TableField(value = "viewdescription")
    @JSONField(name = "viewdescription")
    @JsonProperty("viewdescription")
    private String viewdescription;



    /**
     * 设置 [视图数据信息实体名称]
     */
    public void setIbizviewmessname(String ibizviewmessname) {
        this.ibizviewmessname = ibizviewmessname;
        this.modify("ibizviewmessname", ibizviewmessname);
    }

    /**
     * 设置 [文档地址]
     */
    public void setDocumentaddress(String documentaddress) {
        this.documentaddress = documentaddress;
        this.modify("documentaddress", documentaddress);
    }

    /**
     * 设置 [视图实例地址]
     */
    public void setInstanceaddress(String instanceaddress) {
        this.instanceaddress = instanceaddress;
        this.modify("instanceaddress", instanceaddress);
    }

    /**
     * 设置 [视图类型]
     */
    public void setViewtype(String viewtype) {
        this.viewtype = viewtype;
        this.modify("viewtype", viewtype);
    }

    /**
     * 设置 [视图描述]
     */
    public void setViewdescription(String viewdescription) {
        this.viewdescription = viewdescription;
        this.modify("viewdescription", viewdescription);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizviewmessid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


