package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[统一产品（索引主实体）]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZUNIPRODUCT", resultMap = "IBIZUNIProductResultMap")
public class IBIZUNIProduct extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 单价
     */
    @TableField(value = "unitprice")
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    private Double unitprice;
    /**
     * 产品名称
     */
    @TableField(value = "ibizuniproductname")
    @JSONField(name = "ibizuniproductname")
    @JsonProperty("ibizuniproductname")
    private String ibizuniproductname;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 单位
     */
    @TableField(value = "unit")
    @JSONField(name = "unit")
    @JsonProperty("unit")
    private String unit;
    /**
     * 分组类型
     */
    @TableField(value = "ibizuniproducttype")
    @JSONField(name = "ibizuniproducttype")
    @JsonProperty("ibizuniproducttype")
    private String ibizuniproducttype;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 统一产品标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizuniproductid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizuniproductid")
    @JsonProperty("ibizuniproductid")
    private String ibizuniproductid;



    /**
     * 设置 [单价]
     */
    public void setUnitprice(Double unitprice) {
        this.unitprice = unitprice;
        this.modify("unitprice", unitprice);
    }

    /**
     * 设置 [产品名称]
     */
    public void setIbizuniproductname(String ibizuniproductname) {
        this.ibizuniproductname = ibizuniproductname;
        this.modify("ibizuniproductname", ibizuniproductname);
    }

    /**
     * 设置 [单位]
     */
    public void setUnit(String unit) {
        this.unit = unit;
        this.modify("unit", unit);
    }

    /**
     * 设置 [分组类型]
     */
    public void setIbizuniproducttype(String ibizuniproducttype) {
        this.ibizuniproducttype = ibizuniproducttype;
        this.modify("ibizuniproducttype", ibizuniproducttype);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizuniproductid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


