package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[存储]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSTORAGE", resultMap = "IBIZStorageResultMap")
public class IBIZStorage extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 存储标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizstorageid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizstorageid")
    @JsonProperty("ibizstorageid")
    private String ibizstorageid;
    /**
     * 生产厂商
     */
    @TableField(exist = false)
    @JSONField(name = "producer")
    @JsonProperty("producer")
    private String producer;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 单位
     */
    @TableField(exist = false)
    @JSONField(name = "unit")
    @JsonProperty("unit")
    private String unit;
    /**
     * 分组类型
     */
    @TableField(exist = false)
    @JSONField(name = "ibizhardwaretype")
    @JsonProperty("ibizhardwaretype")
    private String ibizhardwaretype;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 产品编号
     */
    @TableField(exist = false)
    @JSONField(name = "productuid")
    @JsonProperty("productuid")
    private String productuid;
    /**
     * 单价
     */
    @TableField(exist = false)
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    private Double unitprice;
    /**
     * 存储名称
     */
    @TableField(value = "ibizstoragename")
    @JSONField(name = "ibizstoragename")
    @JsonProperty("ibizstoragename")
    private String ibizstoragename;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;



    /**
     * 设置 [存储名称]
     */
    public void setIbizstoragename(String ibizstoragename) {
        this.ibizstoragename = ibizstoragename;
        this.modify("ibizstoragename", ibizstoragename);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizstorageid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


