package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[员工]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0014", resultMap = "IBIZSample0014ResultMap")
public class IBIZSample0014 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 员工名称
     */
    @TableField(value = "ibizsample0014name")
    @JSONField(name = "ibizsample0014name")
    @JsonProperty("ibizsample0014name")
    private String ibizsample0014name;
    /**
     * 员工标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0014id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0014id")
    @JsonProperty("ibizsample0014id")
    private String ibizsample0014id;
    /**
     * 员工编号
     */
    @TableField(value = "sn")
    @JSONField(name = "sn")
    @JsonProperty("sn")
    private String sn;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 名称
     */
    @TableField(exist = false)
    @JSONField(name = "ibizsample0003name")
    @JsonProperty("ibizsample0003name")
    private String ibizsample0003name;
    /**
     * IBIZSAMPLE0003标识
     */
    @TableField(value = "ibizsample0003id")
    @JSONField(name = "ibizsample0003id")
    @JsonProperty("ibizsample0003id")
    private String ibizsample0003id;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.sample.domain.IBIZSample0003 ibizsample0003;



    /**
     * 设置 [员工名称]
     */
    public void setIbizsample0014name(String ibizsample0014name) {
        this.ibizsample0014name = ibizsample0014name;
        this.modify("ibizsample0014name", ibizsample0014name);
    }

    /**
     * 设置 [员工编号]
     */
    public void setSn(String sn) {
        this.sn = sn;
        this.modify("sn", sn);
    }

    /**
     * 设置 [IBIZSAMPLE0003标识]
     */
    public void setIbizsample0003id(String ibizsample0003id) {
        this.ibizsample0003id = ibizsample0003id;
        this.modify("ibizsample0003id", ibizsample0003id);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0014id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


