package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[订单]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0012", resultMap = "IBIZSample0012ResultMap")
public class IBIZSample0012 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 订单标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0012id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0012id")
    @JsonProperty("ibizsample0012id")
    private String ibizsample0012id;
    /**
     * 订单编号
     */
    @DEField(dupCheck = DupCheck.ALL)
    @TableField(value = "orderuid")
    @JSONField(name = "orderuid")
    @JsonProperty("orderuid")
    private String orderuid;
    /**
     * 订单时间
     */
    @TableField(value = "ordertime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ordertime", format = "yyyy-MM-dd")
    @JsonProperty("ordertime")
    private Timestamp ordertime;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 备注
     */
    @TableField(value = "memo")
    @JSONField(name = "memo")
    @JsonProperty("memo")
    private String memo;
    /**
     * 订单名称
     */
    @TableField(value = "ibizsample0012name")
    @JSONField(name = "ibizsample0012name")
    @JsonProperty("ibizsample0012name")
    private String ibizsample0012name;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 订单类型
     */
    @TableField(value = "ordertype")
    @JSONField(name = "ordertype")
    @JsonProperty("ordertype")
    private String ordertype;



    /**
     * 设置 [订单编号]
     */
    public void setOrderuid(String orderuid) {
        this.orderuid = orderuid;
        this.modify("orderuid", orderuid);
    }

    /**
     * 设置 [订单时间]
     */
    public void setOrdertime(Timestamp ordertime) {
        this.ordertime = ordertime;
        this.modify("ordertime", ordertime);
    }

    /**
     * 格式化日期 [订单时间]
     */
    public String formatOrdertime() {
        if (this.ordertime == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(ordertime);
    }
    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [订单名称]
     */
    public void setIbizsample0012name(String ibizsample0012name) {
        this.ibizsample0012name = ibizsample0012name;
        this.modify("ibizsample0012name", ibizsample0012name);
    }

    /**
     * 设置 [订单类型]
     */
    public void setOrdertype(String ordertype) {
        this.ordertype = ordertype;
        this.modify("ordertype", ordertype);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0012id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


