package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[嵌套流程（子）]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0007", resultMap = "IBIZSample0007ResultMap")
public class IBIZSample0007 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 嵌套流程（子）标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0007id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0007id")
    @JsonProperty("ibizsample0007id")
    private String ibizsample0007id;
    /**
     * 工作流版本
     */
    @TableField(value = "wfversion")
    @JSONField(name = "wfversion")
    @JsonProperty("wfversion")
    private String wfversion;
    /**
     * 公文名称
     */
    @TableField(value = "ibizsample0007name")
    @JSONField(name = "ibizsample0007name")
    @JsonProperty("ibizsample0007name")
    private String ibizsample0007name;
    /**
     * 工作流步骤
     */
    @TableField(value = "wfstate")
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    private Integer wfstate;
    /**
     * 业务状态
     */
    @TableField(value = "ywstate")
    @JSONField(name = "ywstate")
    @JsonProperty("ywstate")
    private String ywstate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    private String wfinstanceid;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 会签步骤
     */
    @TableField(value = "wfstep")
    @JSONField(name = "wfstep")
    @JsonProperty("wfstep")
    private String wfstep;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 公文编号
     */
    @TableField(exist = false)
    @JSONField(name = "dnum")
    @JsonProperty("dnum")
    private String dnum;
    /**
     * 公文时间
     */
    @TableField(exist = false)
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ddate", format = "yyyy-MM-dd")
    @JsonProperty("ddate")
    private Timestamp ddate;
    /**
     * 正文
     */
    @TableField(exist = false)
    @JSONField(name = "dtext")
    @JsonProperty("dtext")
    private String dtext;
    /**
     * 嵌套流程（主）名称
     */
    @TableField(exist = false)
    @JSONField(name = "ibizsample0006name")
    @JsonProperty("ibizsample0006name")
    private String ibizsample0006name;
    /**
     * 嵌套流程（主）标识
     */
    @TableField(value = "ibizsample0006id")
    @JSONField(name = "ibizsample0006id")
    @JsonProperty("ibizsample0006id")
    private String ibizsample0006id;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.sample.domain.IBIZSample0006 ibizsample0006;



    /**
     * 设置 [工作流版本]
     */
    public void setWfversion(String wfversion) {
        this.wfversion = wfversion;
        this.modify("wfversion", wfversion);
    }

    /**
     * 设置 [公文名称]
     */
    public void setIbizsample0007name(String ibizsample0007name) {
        this.ibizsample0007name = ibizsample0007name;
        this.modify("ibizsample0007name", ibizsample0007name);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfstate(Integer wfstate) {
        this.wfstate = wfstate;
        this.modify("wfstate", wfstate);
    }

    /**
     * 设置 [业务状态]
     */
    public void setYwstate(String ywstate) {
        this.ywstate = ywstate;
        this.modify("ywstate", ywstate);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfinstanceid(String wfinstanceid) {
        this.wfinstanceid = wfinstanceid;
        this.modify("wfinstanceid", wfinstanceid);
    }

    /**
     * 设置 [会签步骤]
     */
    public void setWfstep(String wfstep) {
        this.wfstep = wfstep;
        this.modify("wfstep", wfstep);
    }

    /**
     * 设置 [嵌套流程（主）标识]
     */
    public void setIbizsample0006id(String ibizsample0006id) {
        this.ibizsample0006id = ibizsample0006id;
        this.modify("ibizsample0006id", ibizsample0006id);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0007id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


