package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[嵌套流程（主）]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0006", resultMap = "IBIZSample0006ResultMap")
public class IBIZSample0006 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 业务状态
     */
    @TableField(value = "ywstate")
    @JSONField(name = "ywstate")
    @JsonProperty("ywstate")
    private String ywstate;
    /**
     * 公文编号
     */
    @TableField(value = "dnum")
    @JSONField(name = "dnum")
    @JsonProperty("dnum")
    private String dnum;
    /**
     * 嵌套流程（主）标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0006id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0006id")
    @JsonProperty("ibizsample0006id")
    private String ibizsample0006id;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 备注
     */
    @TableField(value = "memo")
    @JSONField(name = "memo")
    @JsonProperty("memo")
    private String memo;
    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    private String wfinstanceid;
    /**
     * 会签部门
     */
    @TableField(value = "hqdept")
    @JSONField(name = "hqdept")
    @JsonProperty("hqdept")
    private String hqdept;
    /**
     * 公文日期
     */
    @TableField(value = "ddate")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ddate", format = "yyyy-MM-dd")
    @JsonProperty("ddate")
    private Timestamp ddate;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 公文名称
     */
    @TableField(value = "ibizsample0006name")
    @JSONField(name = "ibizsample0006name")
    @JsonProperty("ibizsample0006name")
    private String ibizsample0006name;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 工作流步骤
     */
    @TableField(value = "wfstate")
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    private Integer wfstate;
    /**
     * 工作流版本
     */
    @TableField(value = "wfversion")
    @JSONField(name = "wfversion")
    @JsonProperty("wfversion")
    private String wfversion;
    /**
     * 流程步骤
     */
    @TableField(value = "wfstep")
    @JSONField(name = "wfstep")
    @JsonProperty("wfstep")
    private String wfstep;
    /**
     * 正文
     */
    @TableField(value = "dtext")
    @JSONField(name = "dtext")
    @JsonProperty("dtext")
    private String dtext;



    /**
     * 设置 [业务状态]
     */
    public void setYwstate(String ywstate) {
        this.ywstate = ywstate;
        this.modify("ywstate", ywstate);
    }

    /**
     * 设置 [公文编号]
     */
    public void setDnum(String dnum) {
        this.dnum = dnum;
        this.modify("dnum", dnum);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfinstanceid(String wfinstanceid) {
        this.wfinstanceid = wfinstanceid;
        this.modify("wfinstanceid", wfinstanceid);
    }

    /**
     * 设置 [会签部门]
     */
    public void setHqdept(String hqdept) {
        this.hqdept = hqdept;
        this.modify("hqdept", hqdept);
    }

    /**
     * 设置 [公文日期]
     */
    public void setDdate(Timestamp ddate) {
        this.ddate = ddate;
        this.modify("ddate", ddate);
    }

    /**
     * 格式化日期 [公文日期]
     */
    public String formatDdate() {
        if (this.ddate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(ddate);
    }
    /**
     * 设置 [公文名称]
     */
    public void setIbizsample0006name(String ibizsample0006name) {
        this.ibizsample0006name = ibizsample0006name;
        this.modify("ibizsample0006name", ibizsample0006name);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfstate(Integer wfstate) {
        this.wfstate = wfstate;
        this.modify("wfstate", wfstate);
    }

    /**
     * 设置 [工作流版本]
     */
    public void setWfversion(String wfversion) {
        this.wfversion = wfversion;
        this.modify("wfversion", wfversion);
    }

    /**
     * 设置 [流程步骤]
     */
    public void setWfstep(String wfstep) {
        this.wfstep = wfstep;
        this.modify("wfstep", wfstep);
    }

    /**
     * 设置 [正文]
     */
    public void setDtext(String dtext) {
        this.dtext = dtext;
        this.modify("dtext", dtext);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0006id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


