package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[多版本流程]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0004", resultMap = "IBIZSample0004ResultMap")
public class IBIZSample0004 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 备注
     */
    @TableField(value = "memo")
    @JSONField(name = "memo")
    @JsonProperty("memo")
    private String memo;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 状态
     */
    @TableField(value = "wfmvstate")
    @JSONField(name = "wfmvstate")
    @JsonProperty("wfmvstate")
    private String wfmvstate;
    /**
     * 订单类型
     */
    @TableField(value = "wfmvtype")
    @JSONField(name = "wfmvtype")
    @JsonProperty("wfmvtype")
    private String wfmvtype;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 订单时间
     */
    @TableField(value = "mvdate")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "mvdate", format = "yyyy-MM-dd")
    @JsonProperty("mvdate")
    private Timestamp mvdate;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 工作流步骤
     */
    @TableField(value = "wfmvstep")
    @JSONField(name = "wfmvstep")
    @JsonProperty("wfmvstep")
    private String wfmvstep;
    /**
     * 工作流版本
     */
    @TableField(value = "wfversion")
    @JSONField(name = "wfversion")
    @JsonProperty("wfversion")
    private String wfversion;
    /**
     * 工作流步骤
     */
    @TableField(value = "wfstate")
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    private Integer wfstate;
    /**
     * 名称
     */
    @TableField(value = "ibizsample0004name")
    @JSONField(name = "ibizsample0004name")
    @JsonProperty("ibizsample0004name")
    private String ibizsample0004name;
    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    private String wfinstanceid;
    /**
     * 多版本流程标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0004id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0004id")
    @JsonProperty("ibizsample0004id")
    private String ibizsample0004id;
    /**
     * 订单金额
     */
    @TableField(value = "je")
    @JSONField(name = "je")
    @JsonProperty("je")
    private BigDecimal je;



    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [状态]
     */
    public void setWfmvstate(String wfmvstate) {
        this.wfmvstate = wfmvstate;
        this.modify("wfmvstate", wfmvstate);
    }

    /**
     * 设置 [订单类型]
     */
    public void setWfmvtype(String wfmvtype) {
        this.wfmvtype = wfmvtype;
        this.modify("wfmvtype", wfmvtype);
    }

    /**
     * 设置 [订单时间]
     */
    public void setMvdate(Timestamp mvdate) {
        this.mvdate = mvdate;
        this.modify("mvdate", mvdate);
    }

    /**
     * 格式化日期 [订单时间]
     */
    public String formatMvdate() {
        if (this.mvdate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(mvdate);
    }
    /**
     * 设置 [工作流步骤]
     */
    public void setWfmvstep(String wfmvstep) {
        this.wfmvstep = wfmvstep;
        this.modify("wfmvstep", wfmvstep);
    }

    /**
     * 设置 [工作流版本]
     */
    public void setWfversion(String wfversion) {
        this.wfversion = wfversion;
        this.modify("wfversion", wfversion);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfstate(Integer wfstate) {
        this.wfstate = wfstate;
        this.modify("wfstate", wfstate);
    }

    /**
     * 设置 [名称]
     */
    public void setIbizsample0004name(String ibizsample0004name) {
        this.ibizsample0004name = ibizsample0004name;
        this.modify("ibizsample0004name", ibizsample0004name);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfinstanceid(String wfinstanceid) {
        this.wfinstanceid = wfinstanceid;
        this.modify("wfinstanceid", wfinstanceid);
    }

    /**
     * 设置 [订单金额]
     */
    public void setJe(BigDecimal je) {
        this.je = je;
        this.modify("je", je);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0004id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


