package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[示例数据库]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE", resultMap = "IBIZSampleResultMap")
public class IBIZSample extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 其他样式链接4
     */
    @TableField(value = "oslink4")
    @JSONField(name = "oslink4")
    @JsonProperty("oslink4")
    private String oslink4;
    /**
     * 分组标题1
     */
    @TableField(value = "title1")
    @JSONField(name = "title1")
    @JsonProperty("title1")
    private String title1;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 示例数据库名称
     */
    @TableField(value = "ibizsamplename")
    @JSONField(name = "ibizsamplename")
    @JsonProperty("ibizsamplename")
    private String ibizsamplename;
    /**
     * 其他样式链接3
     */
    @TableField(value = "oslink3")
    @JSONField(name = "oslink3")
    @JsonProperty("oslink3")
    private String oslink3;
    /**
     * 链接1
     */
    @TableField(value = "link1")
    @JSONField(name = "link1")
    @JsonProperty("link1")
    private String link1;
    /**
     * 示例数据库标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsampleid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsampleid")
    @JsonProperty("ibizsampleid")
    private String ibizsampleid;
    /**
     * 分组标题6
     */
    @TableField(value = "title6")
    @JSONField(name = "title6")
    @JsonProperty("title6")
    private String title6;
    /**
     * 链接6
     */
    @TableField(value = "link6")
    @JSONField(name = "link6")
    @JsonProperty("link6")
    private String link6;
    /**
     * 分组标题5
     */
    @TableField(value = "title5")
    @JSONField(name = "title5")
    @JsonProperty("title5")
    private String title5;
    /**
     * 分组标题4
     */
    @TableField(value = "title4")
    @JSONField(name = "title4")
    @JsonProperty("title4")
    private String title4;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 其他样式链接1
     */
    @TableField(value = "oslink1")
    @JSONField(name = "oslink1")
    @JsonProperty("oslink1")
    private String oslink1;
    /**
     * 其他样式链接5
     */
    @TableField(value = "oslink5")
    @JSONField(name = "oslink5")
    @JsonProperty("oslink5")
    private String oslink5;
    /**
     * 其他样式链接6
     */
    @TableField(value = "oslink6")
    @JSONField(name = "oslink6")
    @JsonProperty("oslink6")
    private String oslink6;
    /**
     * 链接5
     */
    @TableField(value = "link5")
    @JSONField(name = "link5")
    @JsonProperty("link5")
    private String link5;
    /**
     * 链接3
     */
    @TableField(value = "link3")
    @JSONField(name = "link3")
    @JsonProperty("link3")
    private String link3;
    /**
     * 分组标题2
     */
    @TableField(value = "title2")
    @JSONField(name = "title2")
    @JsonProperty("title2")
    private String title2;
    /**
     * 其他样式链接2
     */
    @TableField(value = "oslink2")
    @JSONField(name = "oslink2")
    @JsonProperty("oslink2")
    private String oslink2;
    /**
     * 分组标题3
     */
    @TableField(value = "title3")
    @JSONField(name = "title3")
    @JsonProperty("title3")
    private String title3;
    /**
     * 链接4
     */
    @TableField(value = "link4")
    @JSONField(name = "link4")
    @JsonProperty("link4")
    private String link4;
    /**
     * 链接2
     */
    @TableField(value = "link2")
    @JSONField(name = "link2")
    @JsonProperty("link2")
    private String link2;
    /**
     * 示例类型
     */
    @TableField(value = "sampletype")
    @JSONField(name = "sampletype")
    @JsonProperty("sampletype")
    private String sampletype;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;



    /**
     * 设置 [其他样式链接4]
     */
    public void setOslink4(String oslink4) {
        this.oslink4 = oslink4;
        this.modify("oslink4", oslink4);
    }

    /**
     * 设置 [分组标题1]
     */
    public void setTitle1(String title1) {
        this.title1 = title1;
        this.modify("title1", title1);
    }

    /**
     * 设置 [示例数据库名称]
     */
    public void setIbizsamplename(String ibizsamplename) {
        this.ibizsamplename = ibizsamplename;
        this.modify("ibizsamplename", ibizsamplename);
    }

    /**
     * 设置 [其他样式链接3]
     */
    public void setOslink3(String oslink3) {
        this.oslink3 = oslink3;
        this.modify("oslink3", oslink3);
    }

    /**
     * 设置 [链接1]
     */
    public void setLink1(String link1) {
        this.link1 = link1;
        this.modify("link1", link1);
    }

    /**
     * 设置 [分组标题6]
     */
    public void setTitle6(String title6) {
        this.title6 = title6;
        this.modify("title6", title6);
    }

    /**
     * 设置 [链接6]
     */
    public void setLink6(String link6) {
        this.link6 = link6;
        this.modify("link6", link6);
    }

    /**
     * 设置 [分组标题5]
     */
    public void setTitle5(String title5) {
        this.title5 = title5;
        this.modify("title5", title5);
    }

    /**
     * 设置 [分组标题4]
     */
    public void setTitle4(String title4) {
        this.title4 = title4;
        this.modify("title4", title4);
    }

    /**
     * 设置 [其他样式链接1]
     */
    public void setOslink1(String oslink1) {
        this.oslink1 = oslink1;
        this.modify("oslink1", oslink1);
    }

    /**
     * 设置 [其他样式链接5]
     */
    public void setOslink5(String oslink5) {
        this.oslink5 = oslink5;
        this.modify("oslink5", oslink5);
    }

    /**
     * 设置 [其他样式链接6]
     */
    public void setOslink6(String oslink6) {
        this.oslink6 = oslink6;
        this.modify("oslink6", oslink6);
    }

    /**
     * 设置 [链接5]
     */
    public void setLink5(String link5) {
        this.link5 = link5;
        this.modify("link5", link5);
    }

    /**
     * 设置 [链接3]
     */
    public void setLink3(String link3) {
        this.link3 = link3;
        this.modify("link3", link3);
    }

    /**
     * 设置 [分组标题2]
     */
    public void setTitle2(String title2) {
        this.title2 = title2;
        this.modify("title2", title2);
    }

    /**
     * 设置 [其他样式链接2]
     */
    public void setOslink2(String oslink2) {
        this.oslink2 = oslink2;
        this.modify("oslink2", oslink2);
    }

    /**
     * 设置 [分组标题3]
     */
    public void setTitle3(String title3) {
        this.title3 = title3;
        this.modify("title3", title3);
    }

    /**
     * 设置 [链接4]
     */
    public void setLink4(String link4) {
        this.link4 = link4;
        this.modify("link4", link4);
    }

    /**
     * 设置 [链接2]
     */
    public void setLink2(String link2) {
        this.link2 = link2;
        this.modify("link2", link2);
    }

    /**
     * 设置 [示例类型]
     */
    public void setSampletype(String sampletype) {
        this.sampletype = sampletype;
        this.modify("sampletype", sampletype);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsampleid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


