package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[订单明细]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZORDERDETAIL", resultMap = "IBIZOrderDetailResultMap")
public class IBIZOrderDetail extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 订单明细名称
     */
    @TableField(value = "ibizorderdetailname")
    @JSONField(name = "ibizorderdetailname")
    @JsonProperty("ibizorderdetailname")
    private String ibizorderdetailname;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 测试属性
     */
    @TableField(value = "ibizorderdetaila")
    @JSONField(name = "ibizorderdetaila")
    @JsonProperty("ibizorderdetaila")
    private String ibizorderdetaila;
    /**
     * 小计
     */
    @TableField(exist = false)
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Double amount;
    /**
     * 数量
     */
    @TableField(value = "quantity")
    @JSONField(name = "quantity")
    @JsonProperty("quantity")
    private Integer quantity;
    /**
     * 订单明细标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizorderdetailid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizorderdetailid")
    @JsonProperty("ibizorderdetailid")
    private String ibizorderdetailid;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 单价
     */
    @TableField(value = "unitprice")
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    private Double unitprice;
    /**
     * 订单编号
     */
    @TableField(exist = false)
    @JSONField(name = "orderuid")
    @JsonProperty("orderuid")
    private String orderuid;
    /**
     * 单位
     */
    @TableField(exist = false)
    @JSONField(name = "unit")
    @JsonProperty("unit")
    private String unit;
    /**
     * 订单名称
     */
    @TableField(exist = false)
    @JSONField(name = "ibizordername")
    @JsonProperty("ibizordername")
    private String ibizordername;
    /**
     * 产品名称
     */
    @TableField(exist = false)
    @JSONField(name = "ibizuniproductname")
    @JsonProperty("ibizuniproductname")
    private String ibizuniproductname;
    /**
     * 订单标识
     */
    @TableField(value = "ibizorderid")
    @JSONField(name = "ibizorderid")
    @JsonProperty("ibizorderid")
    private String ibizorderid;
    /**
     * 统一产品标识
     */
    @TableField(value = "ibizuniproductid")
    @JSONField(name = "ibizuniproductid")
    @JsonProperty("ibizuniproductid")
    private String ibizuniproductid;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.sample.domain.IBIZOrder ibizorder;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.sample.domain.IBIZUNIProduct ibizuniproduct;



    /**
     * 设置 [订单明细名称]
     */
    public void setIbizorderdetailname(String ibizorderdetailname) {
        this.ibizorderdetailname = ibizorderdetailname;
        this.modify("ibizorderdetailname", ibizorderdetailname);
    }

    /**
     * 设置 [测试属性]
     */
    public void setIbizorderdetaila(String ibizorderdetaila) {
        this.ibizorderdetaila = ibizorderdetaila;
        this.modify("ibizorderdetaila", ibizorderdetaila);
    }

    /**
     * 设置 [数量]
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
        this.modify("quantity", quantity);
    }

    /**
     * 设置 [单价]
     */
    public void setUnitprice(Double unitprice) {
        this.unitprice = unitprice;
        this.modify("unitprice", unitprice);
    }

    /**
     * 设置 [订单标识]
     */
    public void setIbizorderid(String ibizorderid) {
        this.ibizorderid = ibizorderid;
        this.modify("ibizorderid", ibizorderid);
    }

    /**
     * 设置 [统一产品标识]
     */
    public void setIbizuniproductid(String ibizuniproductid) {
        this.ibizuniproductid = ibizuniproductid;
        this.modify("ibizuniproductid", ibizuniproductid);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizorderdetailid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


