package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[硬件]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZHARDWARE", resultMap = "IBIZHardwareResultMap")
public class IBIZHardware extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 单位
     */
    @TableField(value = "unit")
    @JSONField(name = "unit")
    @JsonProperty("unit")
    private String unit;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 分组类型
     */
    @TableField(value = "ibizhardwaretype")
    @JSONField(name = "ibizhardwaretype")
    @JsonProperty("ibizhardwaretype")
    private String ibizhardwaretype;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 产品编号
     */
    @TableField(value = "productuid")
    @JSONField(name = "productuid")
    @JsonProperty("productuid")
    private String productuid;
    /**
     * 硬件标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizhardwareid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizhardwareid")
    @JsonProperty("ibizhardwareid")
    private String ibizhardwareid;
    /**
     * 名称
     */
    @TableField(value = "ibizhardwarename")
    @JSONField(name = "ibizhardwarename")
    @JsonProperty("ibizhardwarename")
    private String ibizhardwarename;
    /**
     * 单价
     */
    @TableField(value = "unitprice")
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    private Double unitprice;
    /**
     * 生产厂商
     */
    @TableField(value = "producer")
    @JSONField(name = "producer")
    @JsonProperty("producer")
    private String producer;



    /**
     * 设置 [单位]
     */
    public void setUnit(String unit) {
        this.unit = unit;
        this.modify("unit", unit);
    }

    /**
     * 设置 [分组类型]
     */
    public void setIbizhardwaretype(String ibizhardwaretype) {
        this.ibizhardwaretype = ibizhardwaretype;
        this.modify("ibizhardwaretype", ibizhardwaretype);
    }

    /**
     * 设置 [产品编号]
     */
    public void setProductuid(String productuid) {
        this.productuid = productuid;
        this.modify("productuid", productuid);
    }

    /**
     * 设置 [名称]
     */
    public void setIbizhardwarename(String ibizhardwarename) {
        this.ibizhardwarename = ibizhardwarename;
        this.modify("ibizhardwarename", ibizhardwarename);
    }

    /**
     * 设置 [单价]
     */
    public void setUnitprice(Double unitprice) {
        this.unitprice = unitprice;
        this.modify("unitprice", unitprice);
    }

    /**
     * 设置 [生产厂商]
     */
    public void setProducer(String producer) {
        this.producer = producer;
        this.modify("producer", producer);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizhardwareid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


