package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[图书]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZBOOK", resultMap = "IBIZBOOKResultMap")
public class IBIZBOOK extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 图书名称
     */
    @TableField(value = "ibizbookname")
    @JSONField(name = "ibizbookname")
    @JsonProperty("ibizbookname")
    private String ibizbookname;
    /**
     * 图书标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizbookid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizbookid")
    @JsonProperty("ibizbookid")
    private String ibizbookid;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 图书作者
     */
    @TableField(value = "author")
    @JSONField(name = "author")
    @JsonProperty("author")
    private String author;
    /**
     * 图书价格
     */
    @TableField(value = "price")
    @JSONField(name = "price")
    @JsonProperty("price")
    private Double price;
    /**
     * 图书出版社
     */
    @TableField(value = "press")
    @JSONField(name = "press")
    @JsonProperty("press")
    private String press;
    /**
     * 图书类型
     */
    @TableField(value = "type")
    @JSONField(name = "type")
    @JsonProperty("type")
    private String type;
    /**
     * 图书数量
     */
    @TableField(value = "booknumber")
    @JSONField(name = "booknumber")
    @JsonProperty("booknumber")
    private Integer booknumber;
    /**
     * 图书描述
     */
    @TableField(value = "subtext")
    @JSONField(name = "subtext")
    @JsonProperty("subtext")
    private String subtext;
    /**
     * 借出日期
     */
    @TableField(value = "lendouttime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "lendouttime", format = "yyyy-MM-dd")
    @JsonProperty("lendouttime")
    private Timestamp lendouttime;
    /**
     * 归还日期
     */
    @TableField(value = "returntime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "returntime", format = "yyyy-MM-dd")
    @JsonProperty("returntime")
    private Timestamp returntime;
    /**
     * 图标
     */
    @TableField(value = "icon")
    @JSONField(name = "icon")
    @JsonProperty("icon")
    private String icon;
    /**
     * 图书销售状态
     */
    @TableField(value = "sailstate")
    @JSONField(name = "sailstate")
    @JsonProperty("sailstate")
    private String sailstate;
    /**
     * 图书借阅状态
     */
    @TableField(value = "borrowstatus")
    @JSONField(name = "borrowstatus")
    @JsonProperty("borrowstatus")
    private Integer borrowstatus;
    /**
     * 步骤
     */
    @TableField(value = "stepstatus")
    @JSONField(name = "stepstatus")
    @JsonProperty("stepstatus")
    private String stepstatus;
    /**
     * 借阅人
     */
    @TableField(value = "borrower")
    @JSONField(name = "borrower")
    @JsonProperty("borrower")
    private String borrower;
    /**
     * 借阅方式
     */
    @TableField(value = "borrowway")
    @JSONField(name = "borrowway")
    @JsonProperty("borrowway")
    private String borrowway;
    /**
     * 归还图馆
     */
    @TableField(value = "returnlib")
    @JSONField(name = "returnlib")
    @JsonProperty("returnlib")
    private String returnlib;
    /**
     * 借阅人ID
     */
    @TableField(value = "borrowerid")
    @JSONField(name = "borrowerid")
    @JsonProperty("borrowerid")
    private String borrowerid;
    /**
     * 借阅人1
     */
    @TableField(value = "borrower1")
    @JSONField(name = "borrower1")
    @JsonProperty("borrower1")
    private String borrower1;
    /**
     * 借阅人1_ID
     */
    @DEField(name = "borrower1_id")
    @TableField(value = "borrower1_id")
    @JSONField(name = "borrower1_id")
    @JsonProperty("borrower1_id")
    private String borrower1Id;
    /**
     * 借阅人2
     */
    @TableField(value = "borrower2")
    @JSONField(name = "borrower2")
    @JsonProperty("borrower2")
    private String borrower2;
    /**
     * 借阅人2_ID
     */
    @DEField(name = "borrower2_id")
    @TableField(value = "borrower2_id")
    @JSONField(name = "borrower2_id")
    @JsonProperty("borrower2_id")
    private String borrower2Id;
    /**
     * 借阅人3
     */
    @TableField(value = "borrower3")
    @JSONField(name = "borrower3")
    @JsonProperty("borrower3")
    private String borrower3;
    /**
     * 借阅人3_ID
     */
    @DEField(name = "borrower3_id")
    @TableField(value = "borrower3_id")
    @JSONField(name = "borrower3_id")
    @JsonProperty("borrower3_id")
    private String borrower3Id;
    /**
     * 标签
     */
    @TableField(value = "tag")
    @JSONField(name = "tag")
    @JsonProperty("tag")
    private String tag;



    /**
     * 设置 [图书名称]
     */
    public void setIbizbookname(String ibizbookname) {
        this.ibizbookname = ibizbookname;
        this.modify("ibizbookname", ibizbookname);
    }

    /**
     * 设置 [图书作者]
     */
    public void setAuthor(String author) {
        this.author = author;
        this.modify("author", author);
    }

    /**
     * 设置 [图书价格]
     */
    public void setPrice(Double price) {
        this.price = price;
        this.modify("price", price);
    }

    /**
     * 设置 [图书出版社]
     */
    public void setPress(String press) {
        this.press = press;
        this.modify("press", press);
    }

    /**
     * 设置 [图书类型]
     */
    public void setType(String type) {
        this.type = type;
        this.modify("type", type);
    }

    /**
     * 设置 [图书数量]
     */
    public void setBooknumber(Integer booknumber) {
        this.booknumber = booknumber;
        this.modify("booknumber", booknumber);
    }

    /**
     * 设置 [图书描述]
     */
    public void setSubtext(String subtext) {
        this.subtext = subtext;
        this.modify("subtext", subtext);
    }

    /**
     * 设置 [借出日期]
     */
    public void setLendouttime(Timestamp lendouttime) {
        this.lendouttime = lendouttime;
        this.modify("lendouttime", lendouttime);
    }

    /**
     * 格式化日期 [借出日期]
     */
    public String formatLendouttime() {
        if (this.lendouttime == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(lendouttime);
    }
    /**
     * 设置 [归还日期]
     */
    public void setReturntime(Timestamp returntime) {
        this.returntime = returntime;
        this.modify("returntime", returntime);
    }

    /**
     * 格式化日期 [归还日期]
     */
    public String formatReturntime() {
        if (this.returntime == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(returntime);
    }
    /**
     * 设置 [图标]
     */
    public void setIcon(String icon) {
        this.icon = icon;
        this.modify("icon", icon);
    }

    /**
     * 设置 [图书销售状态]
     */
    public void setSailstate(String sailstate) {
        this.sailstate = sailstate;
        this.modify("sailstate", sailstate);
    }

    /**
     * 设置 [图书借阅状态]
     */
    public void setBorrowstatus(Integer borrowstatus) {
        this.borrowstatus = borrowstatus;
        this.modify("borrowstatus", borrowstatus);
    }

    /**
     * 设置 [步骤]
     */
    public void setStepstatus(String stepstatus) {
        this.stepstatus = stepstatus;
        this.modify("stepstatus", stepstatus);
    }

    /**
     * 设置 [借阅人]
     */
    public void setBorrower(String borrower) {
        this.borrower = borrower;
        this.modify("borrower", borrower);
    }

    /**
     * 设置 [借阅方式]
     */
    public void setBorrowway(String borrowway) {
        this.borrowway = borrowway;
        this.modify("borrowway", borrowway);
    }

    /**
     * 设置 [归还图馆]
     */
    public void setReturnlib(String returnlib) {
        this.returnlib = returnlib;
        this.modify("returnlib", returnlib);
    }

    /**
     * 设置 [借阅人ID]
     */
    public void setBorrowerid(String borrowerid) {
        this.borrowerid = borrowerid;
        this.modify("borrowerid", borrowerid);
    }

    /**
     * 设置 [借阅人1]
     */
    public void setBorrower1(String borrower1) {
        this.borrower1 = borrower1;
        this.modify("borrower1", borrower1);
    }

    /**
     * 设置 [借阅人1_ID]
     */
    public void setBorrower1Id(String borrower1Id) {
        this.borrower1Id = borrower1Id;
        this.modify("borrower1_id", borrower1Id);
    }

    /**
     * 设置 [借阅人2]
     */
    public void setBorrower2(String borrower2) {
        this.borrower2 = borrower2;
        this.modify("borrower2", borrower2);
    }

    /**
     * 设置 [借阅人2_ID]
     */
    public void setBorrower2Id(String borrower2Id) {
        this.borrower2Id = borrower2Id;
        this.modify("borrower2_id", borrower2Id);
    }

    /**
     * 设置 [借阅人3]
     */
    public void setBorrower3(String borrower3) {
        this.borrower3 = borrower3;
        this.modify("borrower3", borrower3);
    }

    /**
     * 设置 [借阅人3_ID]
     */
    public void setBorrower3Id(String borrower3Id) {
        this.borrower3Id = borrower3Id;
        this.modify("borrower3_id", borrower3Id);
    }

    /**
     * 设置 [标签]
     */
    public void setTag(String tag) {
        this.tag = tag;
        this.modify("tag", tag);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizbookid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


