package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[编辑器]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZAPPEDITOR", resultMap = "IBIZAPPEDITORResultMap")
public class IBIZAPPEDITOR extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 编辑器名称
     */
    @TableField(value = "ibizappeditorname")
    @JSONField(name = "ibizappeditorname")
    @JsonProperty("ibizappeditorname")
    private String ibizappeditorname;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 编辑器标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizappeditorid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizappeditorid")
    @JsonProperty("ibizappeditorid")
    private String ibizappeditorid;
    /**
     * 编辑器类型
     */
    @TableField(value = "ibizappeditortype")
    @JSONField(name = "ibizappeditortype")
    @JsonProperty("ibizappeditortype")
    private String ibizappeditortype;
    /**
     * 编辑器描述
     */
    @TableField(value = "rditordescription")
    @JSONField(name = "rditordescription")
    @JsonProperty("rditordescription")
    private String rditordescription;
    /**
     * 文档地址
     */
    @TableField(value = "documentaddress")
    @JSONField(name = "documentaddress")
    @JsonProperty("documentaddress")
    private String documentaddress;
    /**
     * 数量
     */
    @TableField(value = "amount")
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Integer amount;
    /**
     * 是否为扩展编辑器
     */
    @TableField(value = "isextendeditor")
    @JSONField(name = "isextendeditor")
    @JsonProperty("isextendeditor")
    private String isextendeditor;



    /**
     * 设置 [编辑器名称]
     */
    public void setIbizappeditorname(String ibizappeditorname) {
        this.ibizappeditorname = ibizappeditorname;
        this.modify("ibizappeditorname", ibizappeditorname);
    }

    /**
     * 设置 [编辑器类型]
     */
    public void setIbizappeditortype(String ibizappeditortype) {
        this.ibizappeditortype = ibizappeditortype;
        this.modify("ibizappeditortype", ibizappeditortype);
    }

    /**
     * 设置 [编辑器描述]
     */
    public void setRditordescription(String rditordescription) {
        this.rditordescription = rditordescription;
        this.modify("rditordescription", rditordescription);
    }

    /**
     * 设置 [文档地址]
     */
    public void setDocumentaddress(String documentaddress) {
        this.documentaddress = documentaddress;
        this.modify("documentaddress", documentaddress);
    }

    /**
     * 设置 [数量]
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [是否为扩展编辑器]
     */
    public void setIsextendeditor(String isextendeditor) {
        this.isextendeditor = isextendeditor;
        this.modify("isextendeditor", isextendeditor);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizappeditorid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


