package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[应用部件]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZAPPCTRL", resultMap = "IBIZAPPCTRLResultMap")
public class IBIZAPPCTRL extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 应用部件名称
     */
    @TableField(value = "ibizappctrlname")
    @JSONField(name = "ibizappctrlname")
    @JsonProperty("ibizappctrlname")
    private String ibizappctrlname;
    /**
     * 应用部件标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizappctrlid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizappctrlid")
    @JsonProperty("ibizappctrlid")
    private String ibizappctrlid;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 应用部件类型
     */
    @TableField(value = "ibizappctrltype")
    @JSONField(name = "ibizappctrltype")
    @JsonProperty("ibizappctrltype")
    private String ibizappctrltype;
    /**
     * 部件描述
     */
    @TableField(value = "ctrldescription")
    @JSONField(name = "ctrldescription")
    @JsonProperty("ctrldescription")
    private String ctrldescription;
    /**
     * 文档地址
     */
    @TableField(value = "documentaddress")
    @JSONField(name = "documentaddress")
    @JsonProperty("documentaddress")
    private String documentaddress;
    /**
     * 数量
     */
    @TableField(value = "amount")
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Integer amount;



    /**
     * 设置 [应用部件名称]
     */
    public void setIbizappctrlname(String ibizappctrlname) {
        this.ibizappctrlname = ibizappctrlname;
        this.modify("ibizappctrlname", ibizappctrlname);
    }

    /**
     * 设置 [应用部件类型]
     */
    public void setIbizappctrltype(String ibizappctrltype) {
        this.ibizappctrltype = ibizappctrltype;
        this.modify("ibizappctrltype", ibizappctrltype);
    }

    /**
     * 设置 [部件描述]
     */
    public void setCtrldescription(String ctrldescription) {
        this.ctrldescription = ctrldescription;
        this.modify("ctrldescription", ctrldescription);
    }

    /**
     * 设置 [文档地址]
     */
    public void setDocumentaddress(String documentaddress) {
        this.documentaddress = documentaddress;
        this.modify("documentaddress", documentaddress);
    }

    /**
     * 设置 [数量]
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizappctrlid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


