package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZOrder;
import cn.ibizlab.core.sample.service.IIBIZOrderService;
import cn.ibizlab.core.sample.filter.IBIZOrderSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单" })
@RestController("DemoAPI-ibizorder")
@RequestMapping("")
public class IBIZOrderResource {

    @Autowired
    public IIBIZOrderService ibizorderService;

    @Autowired
    @Lazy
    public IBIZOrderMapping ibizorderMapping;

    @PreAuthorize("hasPermission(this.ibizorderMapping.toDomain(#ibizorderdto),'DemoSys-IBIZOrder-Create')")
    @ApiOperation(value = "新建订单", tags = {"订单" },  notes = "新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders")
    public ResponseEntity<IBIZOrderDTO> create(@Validated @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
		ibizorderService.create(domain);
        IBIZOrderDTO dto = ibizorderMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizorderMapping.toDomain(#ibizorderdtos),'DemoSys-IBIZOrder-Create')")
    @ApiOperation(value = "批量新建订单", tags = {"订单" },  notes = "批量新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZOrderDTO> ibizorderdtos) {
        ibizorderService.createBatch(ibizorderMapping.toDomain(ibizorderdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-CreateTemp-all')")
    @ApiOperation(value = "CreateTemp", tags = {"订单" },  notes = "CreateTemp")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/{ibizorder_id}/createtemp")
    public ResponseEntity<IBIZOrderDTO> createTemp(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderService.createTemp(domain);
        ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-CreateTempMajor-all')")
    @ApiOperation(value = "CreateTempMajor", tags = {"订单" },  notes = "CreateTempMajor")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/{ibizorder_id}/createtempmajor")
    public ResponseEntity<IBIZOrderDTO> createTempMajor(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderService.createTempMajor(domain);
        ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }

    @VersionCheck(entity = "ibizorder" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizorderService.get(#ibizorder_id),'DemoSys-IBIZOrder-Update')")
    @ApiOperation(value = "更新订单", tags = {"订单" },  notes = "更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorders/{ibizorder_id}")
    public ResponseEntity<IBIZOrderDTO> update(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
		IBIZOrder domain  = ibizorderMapping.toDomain(ibizorderdto);
        domain .setIbizorderid(ibizorder_id);
		ibizorderService.update(domain );
		IBIZOrderDTO dto = ibizorderMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizorderService.getIbizorderByEntities(this.ibizorderMapping.toDomain(#ibizorderdtos)),'DemoSys-IBIZOrder-Update')")
    @ApiOperation(value = "批量更新订单", tags = {"订单" },  notes = "批量更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorders/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZOrderDTO> ibizorderdtos) {
        ibizorderService.updateBatch(ibizorderMapping.toDomain(ibizorderdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-UpdateTemp-all')")
    @ApiOperation(value = "UpdateTemp", tags = {"订单" },  notes = "UpdateTemp")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorders/{ibizorder_id}/updatetemp")
    public ResponseEntity<IBIZOrderDTO> updateTemp(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderService.updateTemp(domain);
        ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-UpdateTempMajor-all')")
    @ApiOperation(value = "UpdateTempMajor", tags = {"订单" },  notes = "UpdateTempMajor")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorders/{ibizorder_id}/updatetempmajor")
    public ResponseEntity<IBIZOrderDTO> updateTempMajor(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderService.updateTempMajor(domain);
        ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }

    @PreAuthorize("hasPermission(this.ibizorderService.get(#ibizorder_id),'DemoSys-IBIZOrder-Remove')")
    @ApiOperation(value = "删除订单", tags = {"订单" },  notes = "删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorders/{ibizorder_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizorder_id") String ibizorder_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizorderService.remove(ibizorder_id));
    }

    @PreAuthorize("hasPermission(this.ibizorderService.getIbizorderByIds(#ids),'DemoSys-IBIZOrder-Remove')")
    @ApiOperation(value = "批量删除订单", tags = {"订单" },  notes = "批量删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorders/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizorderService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-RemoveTemp-all')")
    @ApiOperation(value = "RemoveTemp", tags = {"订单" },  notes = "RemoveTemp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorders/{ibizorder_id}/removetemp")
    public ResponseEntity<IBIZOrderDTO> removeTemp(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderService.removeTemp(domain);
        ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-RemoveTempMajor-all')")
    @ApiOperation(value = "RemoveTempMajor", tags = {"订单" },  notes = "RemoveTempMajor")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorders/{ibizorder_id}/removetempmajor")
    public ResponseEntity<IBIZOrderDTO> removeTempMajor(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderService.removeTempMajor(domain);
        ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }

    @PostAuthorize("hasPermission(this.ibizorderMapping.toDomain(returnObject.body),'DemoSys-IBIZOrder-Get')")
    @ApiOperation(value = "获取订单", tags = {"订单" },  notes = "获取订单")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorders/{ibizorder_id}")
    public ResponseEntity<IBIZOrderDTO> get(@PathVariable("ibizorder_id") String ibizorder_id) {
        IBIZOrder domain = ibizorderService.get(ibizorder_id);
        IBIZOrderDTO dto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-GetTemp-all')")
    @ApiOperation(value = "GetTemp", tags = {"订单" },  notes = "GetTemp")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorders/{ibizorder_id}/gettemp")
    public ResponseEntity<IBIZOrderDTO> getTemp(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderService.getTemp(domain);
        ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-GetTempMajor-all')")
    @ApiOperation(value = "GetTempMajor", tags = {"订单" },  notes = "GetTempMajor")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorders/{ibizorder_id}/gettempmajor")
    public ResponseEntity<IBIZOrderDTO> getTempMajor(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderService.getTempMajor(domain);
        ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }

    @ApiOperation(value = "获取订单草稿", tags = {"订单" },  notes = "获取订单草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorders/getdraft")
    public ResponseEntity<IBIZOrderDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderMapping.toDto(ibizorderService.getDraft(new IBIZOrder())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-GetDraftTemp-all')")
    @ApiOperation(value = "GetDraftTemp", tags = {"订单" },  notes = "GetDraftTemp")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorders/getdrafttemp")
    public ResponseEntity<IBIZOrderDTO> getDraftTemp() {
        IBIZOrder domain =new IBIZOrder();
        domain = ibizorderService.getDraftTemp(domain);
        IBIZOrderDTO ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-GetDraftTempMajor-all')")
    @ApiOperation(value = "GetDraftTempMajor", tags = {"订单" },  notes = "GetDraftTempMajor")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorders/{ibizorder_id}/getdrafttempmajor")
    public ResponseEntity<IBIZOrderDTO> getDraftTempMajor(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderService.getDraftTempMajor(domain);
        ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-BUIAction-all')")
    @ApiOperation(value = "后台界面行为", tags = {"订单" },  notes = "后台界面行为")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/{ibizorder_id}/buiaction")
    public ResponseEntity<IBIZOrderDTO> bUIAction(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDTO ibizorderdto) {
        IBIZOrder domain = ibizorderMapping.toDomain(ibizorderdto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderService.bUIAction(domain);
        ibizorderdto = ibizorderMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdto);
    }
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-BUIAction-all')")
    @ApiOperation(value = "批量处理[后台界面行为]", tags = {"订单" },  notes = "批量处理[后台界面行为]")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/{ibizorder_id}/buiactionbatch")
    public ResponseEntity<Boolean> bUIActionBatch(@RequestBody List<IBIZOrderDTO> ibizorderdtos) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderService.bUIActionBatch(ibizorderMapping.toDomain(ibizorderdtos)));
    }

    @ApiOperation(value = "检查订单", tags = {"订单" },  notes = "检查订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZOrderDTO ibizorderdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizorderService.checkKey(ibizorderMapping.toDomain(ibizorderdto)));
    }

    @PreAuthorize("hasPermission(this.ibizorderMapping.toDomain(#ibizorderdto),'DemoSys-IBIZOrder-Save')")
    @ApiOperation(value = "保存订单", tags = {"订单" },  notes = "保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZOrderDTO ibizorderdto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderService.save(ibizorderMapping.toDomain(ibizorderdto)));
    }

    @PreAuthorize("hasPermission(this.ibizorderMapping.toDomain(#ibizorderdtos),'DemoSys-IBIZOrder-Save')")
    @ApiOperation(value = "批量保存订单", tags = {"订单" },  notes = "批量保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZOrderDTO> ibizorderdtos) {
        ibizorderService.saveBatch(ibizorderMapping.toDomain(ibizorderdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchCSDY-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取测试打印", tags = {"订单" } ,notes = "获取测试打印")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchcsdy")
	public ResponseEntity<List<IBIZOrderDTO>> fetchCSDY(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchCSDY(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchCSDY-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询测试打印", tags = {"订单" } ,notes = "查询测试打印")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchcsdy")
	public ResponseEntity<Page<IBIZOrderDTO>> searchCSDY(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchCSDY(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchCurState30-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取当前用户已审核", tags = {"订单" } ,notes = "获取当前用户已审核")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchcurstate30")
	public ResponseEntity<List<IBIZOrderDTO>> fetchCurState30(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchCurState30(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchCurState30-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询当前用户已审核", tags = {"订单" } ,notes = "查询当前用户已审核")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchcurstate30")
	public ResponseEntity<Page<IBIZOrderDTO>> searchCurState30(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchCurState30(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDDJETJBB-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取订单金额统计报表", tags = {"订单" } ,notes = "获取订单金额统计报表")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchddjetjbb")
	public ResponseEntity<List<IBIZOrderDTO>> fetchDDJETJBB(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchDDJETJBB(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDDJETJBB-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询订单金额统计报表", tags = {"订单" } ,notes = "查询订单金额统计报表")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchddjetjbb")
	public ResponseEntity<Page<IBIZOrderDTO>> searchDDJETJBB(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchDDJETJBB(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDDReport-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取订单报表打印", tags = {"订单" } ,notes = "获取订单报表打印")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchddreport")
	public ResponseEntity<List<IBIZOrderDTO>> fetchDDReport(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchDDReport(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDDReport-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询订单报表打印", tags = {"订单" } ,notes = "查询订单报表打印")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchddreport")
	public ResponseEntity<Page<IBIZOrderDTO>> searchDDReport(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchDDReport(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDYDDMXSJY-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取打印订单明细数据源", tags = {"订单" } ,notes = "获取打印订单明细数据源")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchdyddmxsjy")
	public ResponseEntity<List<IBIZOrderDTO>> fetchDYDDMXSJY(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchDYDDMXSJY(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDYDDMXSJY-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询打印订单明细数据源", tags = {"订单" } ,notes = "查询打印订单明细数据源")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchdyddmxsjy")
	public ResponseEntity<Page<IBIZOrderDTO>> searchDYDDMXSJY(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchDYDDMXSJY(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"订单" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchdefault")
	public ResponseEntity<List<IBIZOrderDTO>> fetchDefault(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchDefault(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"订单" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchdefault")
	public ResponseEntity<Page<IBIZOrderDTO>> searchDefault(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchEchartsDefaultDataSource-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取图表默认数据源", tags = {"订单" } ,notes = "获取图表默认数据源")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchechartsdefaultdatasource")
	public ResponseEntity<List<IBIZOrderDTO>> fetchEchartsDefaultDataSource(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchEchartsDefaultDataSource(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchEchartsDefaultDataSource-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询图表默认数据源", tags = {"订单" } ,notes = "查询图表默认数据源")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchechartsdefaultdatasource")
	public ResponseEntity<Page<IBIZOrderDTO>> searchEchartsDefaultDataSource(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchEchartsDefaultDataSource(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchGaugeDataSource-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取仪表盘数据源", tags = {"订单" } ,notes = "获取仪表盘数据源")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchgaugedatasource")
	public ResponseEntity<List<IBIZOrderDTO>> fetchGaugeDataSource(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchGaugeDataSource(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchGaugeDataSource-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询仪表盘数据源", tags = {"订单" } ,notes = "查询仪表盘数据源")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchgaugedatasource")
	public ResponseEntity<Page<IBIZOrderDTO>> searchGaugeDataSource(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchGaugeDataSource(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchGaugeDataSourceByTime-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取仪表数据源（时间）", tags = {"订单" } ,notes = "获取仪表数据源（时间）")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchgaugedatasourcebytime")
	public ResponseEntity<List<IBIZOrderDTO>> fetchGaugeDataSourceByTime(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchGaugeDataSourceByTime(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchGaugeDataSourceByTime-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询仪表数据源（时间）", tags = {"订单" } ,notes = "查询仪表数据源（时间）")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchgaugedatasourcebytime")
	public ResponseEntity<Page<IBIZOrderDTO>> searchGaugeDataSourceByTime(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchGaugeDataSourceByTime(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchLOGIC_22-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取当前用户审核通过与全部取消", tags = {"订单" } ,notes = "获取当前用户审核通过与全部取消")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchlogic_22")
	public ResponseEntity<List<IBIZOrderDTO>> fetchLOGIC_22(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchLOGIC_22(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchLOGIC_22-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询当前用户审核通过与全部取消", tags = {"订单" } ,notes = "查询当前用户审核通过与全部取消")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchlogic_22")
	public ResponseEntity<Page<IBIZOrderDTO>> searchLOGIC_22(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchLOGIC_22(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchRadarDataSource-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取雷达图数据源", tags = {"订单" } ,notes = "获取雷达图数据源")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchradardatasource")
	public ResponseEntity<List<IBIZOrderDTO>> fetchRadarDataSource(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchRadarDataSource(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchRadarDataSource-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询雷达图数据源", tags = {"订单" } ,notes = "查询雷达图数据源")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchradardatasource")
	public ResponseEntity<Page<IBIZOrderDTO>> searchRadarDataSource(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchRadarDataSource(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchSHZOrder-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取审核中订单", tags = {"订单" } ,notes = "获取审核中订单")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchshzorder")
	public ResponseEntity<List<IBIZOrderDTO>> fetchSHZOrder(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchSHZOrder(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchSHZOrder-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询审核中订单", tags = {"订单" } ,notes = "查询审核中订单")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchshzorder")
	public ResponseEntity<Page<IBIZOrderDTO>> searchSHZOrder(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchSHZOrder(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchState10-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取订单状态10", tags = {"订单" } ,notes = "获取订单状态10")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchstate10")
	public ResponseEntity<List<IBIZOrderDTO>> fetchState10(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchState10(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchState10-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询订单状态10", tags = {"订单" } ,notes = "查询订单状态10")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchstate10")
	public ResponseEntity<Page<IBIZOrderDTO>> searchState10(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchState10(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchState30-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取订单状态30", tags = {"订单" } ,notes = "获取订单状态30")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchstate30")
	public ResponseEntity<List<IBIZOrderDTO>> fetchState30(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchState30(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchState30-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询订单状态30", tags = {"订单" } ,notes = "查询订单状态30")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchstate30")
	public ResponseEntity<Page<IBIZOrderDTO>> searchState30(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchState30(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchState40-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取订单状态40", tags = {"订单" } ,notes = "获取订单状态40")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchstate40")
	public ResponseEntity<List<IBIZOrderDTO>> fetchState40(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchState40(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchState40-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询订单状态40", tags = {"订单" } ,notes = "查询订单状态40")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchstate40")
	public ResponseEntity<Page<IBIZOrderDTO>> searchState40(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchState40(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchXECX-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "获取小额查询", tags = {"订单" } ,notes = "获取小额查询")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/fetchxecx")
	public ResponseEntity<List<IBIZOrderDTO>> fetchXECX(IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchXECX(context) ;
        List<IBIZOrderDTO> list = ibizorderMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchXECX-all') and hasPermission(#context,'DemoSys-IBIZOrder-Get')")
	@ApiOperation(value = "查询小额查询", tags = {"订单" } ,notes = "查询小额查询")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/searchxecx")
	public ResponseEntity<Page<IBIZOrderDTO>> searchXECX(@RequestBody IBIZOrderSearchContext context) {
        Page<IBIZOrder> domains = ibizorderService.searchXECX(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    @Autowired
    cn.ibizlab.core.sample.mapping.IBIZOrderImport importImpMapping;

    @RequestMapping(method = RequestMethod.POST, value = "/ibizorders/import")
    public ResponseEntity<JSONObject> importData(@RequestParam(value = "config") String config , @RequestBody List<IBIZOrder> dtos){
        JSONObject rs=new JSONObject();
        if(dtos.size()==0){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            if("Import".equals(config)){
                rs=ibizorderService.importData(importImpMapping.toDomain(dtos),1000,false);
            }
            return ResponseEntity.status(HttpStatus.OK).body(rs);
        }
    }
}

