package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZStorage;
/**
 * 关系型数据实体[IBIZStorage] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("存储")
public class IBIZStorageSearchContext extends QueryWrapperContext<IBIZStorage> {

    @JsonProperty("n_ibizstorageid_eq")
    @JSONField(name = "n_ibizstorageid_eq")
    @ApiModelProperty("存储标识EQ")
	private String ibizStorageIdEQ;
	public IBIZStorageSearchContext setIbizStorageIdEQ(String ibizStorageIdEQ) {
        this.ibizStorageIdEQ = ibizStorageIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizStorageIdEQ)){
            this.getSearchCond().eq("ibizstorageid", ibizStorageIdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizstoragename_like")
    @JSONField(name = "n_ibizstoragename_like")
    @ApiModelProperty("存储名称LIKE")
	private String ibizStorageNameLIKE;
	public IBIZStorageSearchContext setIbizStorageNameLIKE(String ibizStorageNameLIKE) {
        this.ibizStorageNameLIKE = ibizStorageNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizStorageNameLIKE)){
            this.getSearchCond().like("ibizstoragename", ibizStorageNameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizstoragename", query)
            );
		}
	}
}