/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ibizuniproductid',
          prop: 'ibizuniproductid',
          dataType: 'PICKUP',
        },
        {
          name: 'unit',
          prop: 'unit',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'ibizuniproductname',
          prop: 'ibizuniproductname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'ibizsample0012id',
          prop: 'ibizsample0012id',
          dataType: 'PICKUP',
        },
        {
          name: 'unitprice',
          prop: 'unitprice',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'ibizsample0013id',
          prop: 'ibizsample0013id',
          dataType: 'GUID',
        },
        {
          name: 'quantity',
          prop: 'quantity',
          dataType: 'INT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'ibizsample0012name',
          prop: 'ibizsample0012name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizsample0013name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizsample0013id',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizsample0013id',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'ibizsample0013',
          prop: 'ibizsample0013id',
        },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}