import ViewMessageService from '../view-message-service';
/**
 * 区域图视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg80MessageServiceBase
 */
export default class ViewMsg80MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg80MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg80MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg80MessageServiceBase
     */
    public initBasicParam(){
        this.id = "8442acff03d45ce3f32ed7467c000bb3";
        this.name = "区域图";
        this.codename = "ViewMsg80";
        this.title = "";
        this.content = "本实例展示订单金额区域图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg80MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}