import ViewMessageService from '../view-message-service';
/**
 * 表格更新默认值视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg14MessageServiceBase
 */
export default class ViewMsg14MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg14MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg14MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg14MessageServiceBase
     */
    public initBasicParam(){
        this.id = "c309d3f5d747b9aee372f52f30c93253";
        this.name = "表格更新默认值";
        this.codename = "ViewMsg14";
        this.title = "";
        this.content = "本示例展示实体表格的更新默认值功能：表格更新时提供默认值。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg14MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}