// 基于 @CONTROL/向导面板/SERVICE.ts.ftl 生成
import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZOrderService from '@/service/ibizorder/ibizorder-service';
import TestModel from './test-wizardpanel-model';


/**
 * Test 部件服务对象
 *
 * @export
 * @class TestService
 */
export default class TestService extends ControlService {

    /**
     * 订单服务对象
     *
     * @type {IBIZOrderService}
     * @memberof TestService
     */
    public appEntityService: IBIZOrderService = new IBIZOrderService();

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof TestService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of TestService.
     * 
     * @param {*} [opts={}]
     * @memberof TestService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new TestModel();
    }

    /**
     * 初始化向导
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof TestService
     */
    @Errorlog
    public init(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Create(Context,Data, isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 向导结束
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof TestService
     */
    @Errorlog
    public finish(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            // 忽略版本检查
            Object.assign(Data,{ignoreversioncheck:1});
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Update(Context,Data, isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }
}