import { Environment } from '@/environments/environment';
import { UIActionTool,Util } from '@/utils';
import UIService from '../ui-service';
import { Subject } from 'rxjs';
import IBIZBOOKService from '@/service/ibizbook/ibizbook-service';
import IBIZBOOKAuthService from '@/authservice/ibizbook/ibizbook-auth-service';

/**
 * 图书UI服务对象基类
 *
 * @export
 * @class IBIZBOOKUIServiceBase
 */
export default class IBIZBOOKUIServiceBase extends UIService {

    /**
     * 是否支持工作流
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */
    public isEnableWorkflow:boolean = false;

    /**
     * 是否支持实体主状态
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */
    public isEnableDEMainState:boolean = false;

    /**
     * 当前UI服务对应的数据服务对象
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */
    public dataService:IBIZBOOKService = new IBIZBOOKService();

    /**
     * 所有关联视图
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */ 
    public allViewMap: Map<string, Object> = new Map();

    /**
     * 状态值
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */ 
    public stateValue: number = 0;

    /**
     * 状态属性
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */ 
    public stateField: string = "";

    /**
     * 主状态属性集合
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public mainStateFields:Array<any> = [];

    /**
     * 主状态集合Map
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public allDeMainStateMap:Map<string,string> = new Map();

    /**
     * 主状态操作标识Map
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */ 
    public allDeMainStateOPPrivsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  IBIZBOOKUIServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBIZBOOKUIServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
        this.authService = new IBIZBOOKAuthService(opts);
        this.initViewMap();
        this.initDeMainStateMap();
        this.initDeMainStateOPPrivsMap();
    }

    /**
     * 初始化视图Map
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public initViewMap(){
        this.allViewMap.set(':',{viewname:'statewizardview',srfappde:'ibizbooks',component:'ibizbookstate-wizard-view'});
        this.allViewMap.set(':',{viewname:'editview3',srfappde:'ibizbooks',component:'ibizbookedit-view3'});
        this.allViewMap.set(':',{viewname:'autogrouplistview',srfappde:'ibizbooks',component:'ibizbookauto-group-list-view'});
        this.allViewMap.set(':',{viewname:'ruleseditview',srfappde:'ibizbooks',component:'ibizbookrules-edit-view'});
        this.allViewMap.set(':',{viewname:'treegridexview',srfappde:'ibizbooks',component:'ibizbooktree-grid-ex-view'});
        this.allViewMap.set(':',{viewname:'usr7gridview',srfappde:'ibizbooks',component:'ibizbookusr7-grid-view'});
        this.allViewMap.set(':',{viewname:'groupbycodelistkanbanview',srfappde:'ibizbooks',component:'ibizbookgroup-by-codelist-kan-ban-view'});
        this.allViewMap.set(':',{viewname:'usr2gridview',srfappde:'ibizbooks',component:'ibizbookusr2-grid-view'});
        this.allViewMap.set(':',{viewname:'dashboardview',srfappde:'ibizbooks',component:'ibizbookdashboard-view'});
        this.allViewMap.set(':',{viewname:'haspanellistview',srfappde:'ibizbooks',component:'ibizbookhas-panel-list-view'});
        this.allViewMap.set(':',{viewname:'usr2calendarview',srfappde:'ibizbooks',component:'ibizbookusr2-calendar-view'});
        this.allViewMap.set(':',{viewname:'valuerulesgridview',srfappde:'ibizbooks',component:'ibizbookvalue-rules-grid-view'});
        this.allViewMap.set(':',{viewname:'usr2meditview9',srfappde:'ibizbooks',component:'ibizbookusr2-medit-view9'});
        this.allViewMap.set(':',{viewname:'meditview9',srfappde:'ibizbooks',component:'ibizbookmedit-view9'});
        this.allViewMap.set(':',{viewname:'editview2',srfappde:'ibizbooks',component:'ibizbookedit-view2'});
        this.allViewMap.set(':',{viewname:'interfunctreeview',srfappde:'ibizbooks',component:'ibizbookinter-func-tree-view'});
        this.allViewMap.set(':',{viewname:'usr5gridview',srfappde:'ibizbooks',component:'ibizbookusr5-grid-view'});
        this.allViewMap.set(':',{viewname:'usr3calendarview',srfappde:'ibizbooks',component:'ibizbookusr3-calendar-view'});
        this.allViewMap.set(':',{viewname:'usr4gridview',srfappde:'ibizbooks',component:'ibizbookusr4-grid-view'});
        this.allViewMap.set(':',{viewname:'interfunckanbanview',srfappde:'ibizbooks',component:'ibizbookinter-func-kan-ban-view'});
        this.allViewMap.set(':',{viewname:'usr8gridview',srfappde:'ibizbooks',component:'ibizbookusr8-grid-view'});
        this.allViewMap.set(':',{viewname:'wizardview',srfappde:'ibizbooks',component:'ibizbookwizard-view'});
        this.allViewMap.set(':',{viewname:'haspanelkanbanview',srfappde:'ibizbooks',component:'ibizbookhas-panel-kan-ban-view'});
        this.allViewMap.set(':',{viewname:'listview',srfappde:'ibizbooks',component:'ibizbooklist-view'});
        this.allViewMap.set(':',{viewname:'customview',srfappde:'ibizbooks',component:'ibizbookcustom-view'});
        this.allViewMap.set('EDITVIEW:',{viewname:'editview',srfappde:'ibizbooks',component:'ibizbookedit-view'});
        this.allViewMap.set(':',{viewname:'roweditgridview',srfappde:'ibizbooks',component:'ibizbookrow-edit-grid-view'});
        this.allViewMap.set(':',{viewname:'usr6gridview',srfappde:'ibizbooks',component:'ibizbookusr6-grid-view'});
        this.allViewMap.set(':',{viewname:'usr4dataview',srfappde:'ibizbooks',component:'ibizbookusr4-data-view'});
        this.allViewMap.set(':',{viewname:'usr3gridview',srfappde:'ibizbooks',component:'ibizbookusr3-grid-view'});
        this.allViewMap.set(':',{viewname:'dataview',srfappde:'ibizbooks',component:'ibizbookdata-view'});
        this.allViewMap.set(':',{viewname:'interfunceditview',srfappde:'ibizbooks',component:'ibizbookinter-func-edit-view'});
        this.allViewMap.set(':',{viewname:'usr3dataview',srfappde:'ibizbooks',component:'ibizbookusr3-data-view'});
        this.allViewMap.set(':',{viewname:'updatedefaultgridview',srfappde:'ibizbooks',component:'ibizbookupdate-default-grid-view'});
        this.allViewMap.set(':',{viewname:'gridexpview',srfappde:'ibizbooks',component:'ibizbookgrid-exp-view'});
        this.allViewMap.set(':',{viewname:'ganttview',srfappde:'ibizbooks',component:'ibizbookgantt-view'});
        this.allViewMap.set(':',{viewname:'usr2dataview',srfappde:'ibizbooks',component:'ibizbookusr2-data-view'});
        this.allViewMap.set(':',{viewname:'groupbycodelistlistview',srfappde:'ibizbooks',component:'ibizbookgroup-by-codelist-list-view'});
        this.allViewMap.set(':',{viewname:'optionview',srfappde:'ibizbooks',component:'ibizbookoption-view'});
        this.allViewMap.set(':',{viewname:'calendarview',srfappde:'ibizbooks',component:'ibizbookcalendar-view'});
        this.allViewMap.set(':',{viewname:'editview4',srfappde:'ibizbooks',component:'ibizbookedit-view4'});
        this.allViewMap.set(':',{viewname:'internalfuncgridview',srfappde:'ibizbooks',component:'ibizbookinternal-func-grid-view'});
        this.allViewMap.set(':',{viewname:'newdefaultvaluegridview',srfappde:'ibizbooks',component:'ibizbooknew-default-value-grid-view'});
    }

    /**
     * 初始化主状态集合
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public initDeMainStateMap(){
    }

    /**
     * 初始化主状态操作标识
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public initDeMainStateOPPrivsMap(){
    }


    /**
     * 获取指定数据的重定向页面
     * 
     * @param srfkey 数据主键
     * @param isEnableWorkflow  重定向视图是否需要处理流程中的数据
     * @memberof  IBIZBOOKUIServiceBase
     */
    public async getRDAppView(srfkey:string,isEnableWorkflow:boolean){
        this.isEnableWorkflow = isEnableWorkflow;
        // 进行数据查询
        let result:any = await this.dataService.Get({ibizbook:srfkey});
        const curData:any = result.data;
        //判断当前数据模式,默认为true，todo
        const iRealDEModel:boolean = true;

        let bDataInWF:boolean = false;
		let bWFMode:any = false;
		// 计算数据模式
		if (this.isEnableWorkflow) {
			bDataInWF = await this.dataService.testDataInWF({stateValue:this.stateValue,stateField:this.stateField},curData);
			if (bDataInWF) {
				bDataInWF = true;
				bWFMode = await this.dataService.testUserExistWorklist(null,curData);
			}
        }
        let strPDTViewParam:string = await this.getDESDDEViewPDTParam(curData, bDataInWF, bWFMode);
        //若不是当前数据模式，处理strPDTViewParam，todo

        //查找视图

        //返回视图
        return this.allViewMap.get(strPDTViewParam);
    }

    /**
	 * 获取实际的数据类型
     * 
     * @memberof  IBIZBOOKUIServiceBase
	 */
	public getRealDEType(entity:any){

    }

    /**
     * 获取实体单数据实体视图预定义参数
     * 
     * @param curData 当前数据
     * @param bDataInWF 是否有数据在工作流中
     * @param bWFMode   是否工作流模式
     * @memberof  IBIZBOOKUIServiceBase
     */
    public async getDESDDEViewPDTParam(curData:any, bDataInWF:boolean, bWFMode:boolean){
        let strPDTParam:string = '';
		if (bDataInWF) {
			// 判断数据是否在流程中
        }
        //多表单，todo
        const multiFormDEField:string|null =null;

        if (multiFormDEField) {
			const objFormValue:string = curData[multiFormDEField];
			if(!Environment.isAppMode){
				return 'MOBEDITVIEW:'+objFormValue;
			}
			return 'EDITVIEW:'+objFormValue;
        }
		if(!Environment.isAppMode){
            if(this.getDEMainStateTag(curData)){
                return `MOBEDITVIEW:MSTAG:${ this.getDEMainStateTag(curData)}`;
            }
			return 'MOBEDITVIEW:';
        }
        if(this.getDEMainStateTag(curData)){
            return `EDITVIEW:MSTAG:${ this.getDEMainStateTag(curData)}`;
        }
		return 'EDITVIEW:';
    }

    /**
     * 获取数据对象的主状态标识
     * 
     * @param curData 当前数据
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public getDEMainStateTag(curData:any){
        if(this.mainStateFields.length === 0) return null;

        this.mainStateFields.forEach((singleMainField:any) =>{
            if(!(singleMainField in curData)){
                console.warn(`当前数据对象不包含属性「${singleMainField}」，根据「${singleMainField}」属性进行的主状态计算默认为空值`);
            }
        })
        for (let i = 0; i <= 1; i++) {
            let strTag:string = (curData[this.mainStateFields[0]] != null && curData[this.mainStateFields[0]] !== "")?(i == 0) ? `${curData[this.mainStateFields[0]]}` : "":"";
            if (this.mainStateFields.length >= 2) {
                for (let j = 0; j <= 1; j++) {
                    let strTag2:string = (curData[this.mainStateFields[1]] != null && curData[this.mainStateFields[1]] !== "")?`${strTag}__${(j == 0) ? `${curData[this.mainStateFields[1]]}` : ""}`:strTag;
                    if (this.mainStateFields.length >= 3) {
                        for (let k = 0; k <= 1; k++) {
                            let strTag3:string = (curData[this.mainStateFields[2]] != null && curData[this.mainStateFields[2]] !== "")?`${strTag2}__${(k == 0) ? `${curData[this.mainStateFields[2]]}` : ""}`:strTag2;
                            // 判断是否存在
                            return this.allDeMainStateMap.get(strTag3);
                        }
                    }else{
                        return this.allDeMainStateMap.get(strTag2);
                    }
                }
            }else{
                return this.allDeMainStateMap.get(strTag);
            }
        }
        return null;
    }

    /**
    * 获取数据对象当前操作标识
    * 
    * @param data 当前数据
    * @memberof  IBIZBOOKUIServiceBase
    */  
   public getDEMainStateOPPrivs(data:any){
        if(this.getDEMainStateTag(data)){
            return this.allDeMainStateOPPrivsMap.get((this.getDEMainStateTag(data) as string));
        }else{
            return null;
        }
   }

    /**
    * 获取数据对象所有的操作标识
    * 
    * @param data 当前数据
    * @memberof  IBIZBOOKUIServiceBase
    */ 
   public getAllOPPrivs(data:any){
       return this.authService.getOPPrivs(this.getDEMainStateOPPrivs(data));
   }

}