package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZBOOKDTO]
 */
@Data
public class IBIZBOOKDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [IBIZBOOKNAME]
     *
     */
    @JSONField(name = "ibizbookname")
    @JsonProperty("ibizbookname")
    @NotBlank(message = "[图书名称]不允许为空!")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizbookname;

    /**
     * 属性 [IBIZBOOKID]
     *
     */
    @JSONField(name = "ibizbookid")
    @JsonProperty("ibizbookid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizbookid;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [AUTHOR]
     *
     */
    @JSONField(name = "author")
    @JsonProperty("author")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String author;

    /**
     * 属性 [PRICE]
     *
     */
    @JSONField(name = "price")
    @JsonProperty("price")
    private Double price;

    /**
     * 属性 [PRESS]
     *
     */
    @JSONField(name = "press")
    @JsonProperty("press")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String press;

    /**
     * 属性 [TYPE]
     *
     */
    @JSONField(name = "type")
    @JsonProperty("type")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String type;

    /**
     * 属性 [BOOKNUMBER]
     *
     */
    @JSONField(name = "booknumber")
    @JsonProperty("booknumber")
    private Integer booknumber;

    /**
     * 属性 [SUBTEXT]
     *
     */
    @JSONField(name = "subtext")
    @JsonProperty("subtext")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String subtext;

    /**
     * 属性 [LENDOUTTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "lendouttime" , format="yyyy-MM-dd")
    @JsonProperty("lendouttime")
    @NotNull(message = "[借出日期]不允许为空!")
    private Timestamp lendouttime;

    /**
     * 属性 [RETURNTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "returntime" , format="yyyy-MM-dd")
    @JsonProperty("returntime")
    @NotNull(message = "[归还日期]不允许为空!")
    private Timestamp returntime;

    /**
     * 属性 [ICON]
     *
     */
    @JSONField(name = "icon")
    @JsonProperty("icon")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String icon;

    /**
     * 属性 [SAILSTATE]
     *
     */
    @JSONField(name = "sailstate")
    @JsonProperty("sailstate")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String sailstate;


    /**
     * 设置 [IBIZBOOKNAME]
     */
    public void setIbizbookname(String  ibizbookname){
        this.ibizbookname = ibizbookname ;
        this.modify("ibizbookname",ibizbookname);
    }

    /**
     * 设置 [AUTHOR]
     */
    public void setAuthor(String  author){
        this.author = author ;
        this.modify("author",author);
    }

    /**
     * 设置 [PRICE]
     */
    public void setPrice(Double  price){
        this.price = price ;
        this.modify("price",price);
    }

    /**
     * 设置 [PRESS]
     */
    public void setPress(String  press){
        this.press = press ;
        this.modify("press",press);
    }

    /**
     * 设置 [TYPE]
     */
    public void setType(String  type){
        this.type = type ;
        this.modify("type",type);
    }

    /**
     * 设置 [BOOKNUMBER]
     */
    public void setBooknumber(Integer  booknumber){
        this.booknumber = booknumber ;
        this.modify("booknumber",booknumber);
    }

    /**
     * 设置 [SUBTEXT]
     */
    public void setSubtext(String  subtext){
        this.subtext = subtext ;
        this.modify("subtext",subtext);
    }

    /**
     * 设置 [LENDOUTTIME]
     */
    public void setLendouttime(Timestamp  lendouttime){
        this.lendouttime = lendouttime ;
        this.modify("lendouttime",lendouttime);
    }

    /**
     * 设置 [RETURNTIME]
     */
    public void setReturntime(Timestamp  returntime){
        this.returntime = returntime ;
        this.modify("returntime",returntime);
    }

    /**
     * 设置 [ICON]
     */
    public void setIcon(String  icon){
        this.icon = icon ;
        this.modify("icon",icon);
    }

    /**
     * 设置 [SAILSTATE]
     */
    public void setSailstate(String  sailstate){
        this.sailstate = sailstate ;
        this.modify("sailstate",sailstate);
    }


}


