import ViewMessageService from '../view-message-service';
/**
 * 嵌入编辑器视图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg86MessageServiceBase
 */
export default class ViewMsg86MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg86MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg86MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg86MessageServiceBase
     */
    public initBasicParam(){
        this.id = "7a39df9fd17c4dc1f7cb7b6005c605ba";
        this.name = "嵌入编辑器视图";
        this.codename = "ViewMsg86";
        this.title = "";
        this.content = "本示例展示在编辑视图中嵌入另一个视图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg86MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}