import { Http,Util } from '@/utils';
import GridLoadUILogicBase from './grid-load-ui-logic-base';

/**
 * 表格加载
 *
 * @export
 * @class GridLoadUILogic
 */
export default class GridLoadUILogic extends GridLoadUILogicBase {

    /**
     * 表格加载 逻辑实例对象
     *
     * @private
     * @static
     * @type {GridLoadUILogic}
     * @memberof GridLoadUILogic
     */
    private static instance: GridLoadUILogic;

    /**
     * 获取 表格加载 逻辑实例对象
     *
     * @static
     * @return {*}  {GridLoadUILogic}
     * @memberof GridLoadUILogic
     */
    static getInstance(): GridLoadUILogic {
        if (!this.instance) {
            this.instance = new GridLoadUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  GridLoadUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  GridLoadUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}