package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZAPPEDITOR;
import cn.ibizlab.core.sample.service.IIBIZAPPEDITORService;
import cn.ibizlab.core.sample.filter.IBIZAPPEDITORSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"编辑器" })
@RestController("DemoAPI-ibizappeditor")
@RequestMapping("")
public class IBIZAPPEDITORResource {

    @Autowired
    public IIBIZAPPEDITORService ibizappeditorService;

    @Autowired
    @Lazy
    public IBIZAPPEDITORMapping ibizappeditorMapping;

    @PreAuthorize("hasPermission(this.ibizappeditorMapping.toDomain(#ibizappeditordto),'DemoSys-IBIZAPPEDITOR-Create')")
    @ApiOperation(value = "新建编辑器", tags = {"编辑器" },  notes = "新建编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappeditors")
    public ResponseEntity<IBIZAPPEDITORDTO> create(@Validated @RequestBody IBIZAPPEDITORDTO ibizappeditordto) {
        IBIZAPPEDITOR domain = ibizappeditorMapping.toDomain(ibizappeditordto);
		ibizappeditorService.create(domain);
        IBIZAPPEDITORDTO dto = ibizappeditorMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizappeditorMapping.toDomain(#ibizappeditordtos),'DemoSys-IBIZAPPEDITOR-Create')")
    @ApiOperation(value = "批量新建编辑器", tags = {"编辑器" },  notes = "批量新建编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappeditors/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZAPPEDITORDTO> ibizappeditordtos) {
        ibizappeditorService.createBatch(ibizappeditorMapping.toDomain(ibizappeditordtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizappeditor" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizappeditorService.get(#ibizappeditor_id),'DemoSys-IBIZAPPEDITOR-Update')")
    @ApiOperation(value = "更新编辑器", tags = {"编辑器" },  notes = "更新编辑器")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizappeditors/{ibizappeditor_id}")
    public ResponseEntity<IBIZAPPEDITORDTO> update(@PathVariable("ibizappeditor_id") String ibizappeditor_id, @RequestBody IBIZAPPEDITORDTO ibizappeditordto) {
		IBIZAPPEDITOR domain  = ibizappeditorMapping.toDomain(ibizappeditordto);
        domain .setIbizappeditorid(ibizappeditor_id);
		ibizappeditorService.update(domain );
		IBIZAPPEDITORDTO dto = ibizappeditorMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizappeditorService.getIbizappeditorByEntities(this.ibizappeditorMapping.toDomain(#ibizappeditordtos)),'DemoSys-IBIZAPPEDITOR-Update')")
    @ApiOperation(value = "批量更新编辑器", tags = {"编辑器" },  notes = "批量更新编辑器")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizappeditors/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZAPPEDITORDTO> ibizappeditordtos) {
        ibizappeditorService.updateBatch(ibizappeditorMapping.toDomain(ibizappeditordtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizappeditorService.get(#ibizappeditor_id),'DemoSys-IBIZAPPEDITOR-Remove')")
    @ApiOperation(value = "删除编辑器", tags = {"编辑器" },  notes = "删除编辑器")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizappeditors/{ibizappeditor_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizappeditor_id") String ibizappeditor_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizappeditorService.remove(ibizappeditor_id));
    }

    @PreAuthorize("hasPermission(this.ibizappeditorService.getIbizappeditorByIds(#ids),'DemoSys-IBIZAPPEDITOR-Remove')")
    @ApiOperation(value = "批量删除编辑器", tags = {"编辑器" },  notes = "批量删除编辑器")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizappeditors/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizappeditorService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizappeditorMapping.toDomain(returnObject.body),'DemoSys-IBIZAPPEDITOR-Get')")
    @ApiOperation(value = "获取编辑器", tags = {"编辑器" },  notes = "获取编辑器")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizappeditors/{ibizappeditor_id}")
    public ResponseEntity<IBIZAPPEDITORDTO> get(@PathVariable("ibizappeditor_id") String ibizappeditor_id) {
        IBIZAPPEDITOR domain = ibizappeditorService.get(ibizappeditor_id);
        IBIZAPPEDITORDTO dto = ibizappeditorMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取编辑器草稿", tags = {"编辑器" },  notes = "获取编辑器草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizappeditors/getdraft")
    public ResponseEntity<IBIZAPPEDITORDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizappeditorMapping.toDto(ibizappeditorService.getDraft(new IBIZAPPEDITOR())));
    }

    @ApiOperation(value = "检查编辑器", tags = {"编辑器" },  notes = "检查编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappeditors/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZAPPEDITORDTO ibizappeditordto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizappeditorService.checkKey(ibizappeditorMapping.toDomain(ibizappeditordto)));
    }

    @PreAuthorize("hasPermission(this.ibizappeditorMapping.toDomain(#ibizappeditordto),'DemoSys-IBIZAPPEDITOR-Save')")
    @ApiOperation(value = "保存编辑器", tags = {"编辑器" },  notes = "保存编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappeditors/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZAPPEDITORDTO ibizappeditordto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizappeditorService.save(ibizappeditorMapping.toDomain(ibizappeditordto)));
    }

    @PreAuthorize("hasPermission(this.ibizappeditorMapping.toDomain(#ibizappeditordtos),'DemoSys-IBIZAPPEDITOR-Save')")
    @ApiOperation(value = "批量保存编辑器", tags = {"编辑器" },  notes = "批量保存编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappeditors/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZAPPEDITORDTO> ibizappeditordtos) {
        ibizappeditorService.saveBatch(ibizappeditorMapping.toDomain(ibizappeditordtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEDITOR-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZAPPEDITOR-Get')")
	@ApiOperation(value = "获取数据集", tags = {"编辑器" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/ibizappeditors/fetchdefault")
	public ResponseEntity<List<IBIZAPPEDITORDTO>> fetchDefault(IBIZAPPEDITORSearchContext context) {
        Page<IBIZAPPEDITOR> domains = ibizappeditorService.searchDefault(context) ;
        List<IBIZAPPEDITORDTO> list = ibizappeditorMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEDITOR-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZAPPEDITOR-Get')")
	@ApiOperation(value = "查询数据集", tags = {"编辑器" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/ibizappeditors/searchdefault")
	public ResponseEntity<Page<IBIZAPPEDITORDTO>> searchDefault(@RequestBody IBIZAPPEDITORSearchContext context) {
        Page<IBIZAPPEDITOR> domains = ibizappeditorService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizappeditorMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

