package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0019;
import cn.ibizlab.core.sample.service.IBIZSample0019Service;
import cn.ibizlab.core.sample.filter.IBIZSample0019SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"部门" })
@RestController("demoapi-ibizsample0019")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0019Resource {

    @Autowired
    public IBIZSample0019Service ibizSample0019Service;

    @Autowired
    @Lazy
    public IBIZSample0019DTOMapping ibizSample0019DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"部门" },  notes = "IBIZSample0019-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0019-Create-all') or hasPermission(this.ibizSample0019DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0019-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0019s")
    public ResponseEntity<IBIZSample0019DTO> create
            (@Validated @RequestBody IBIZSample0019DTO dto) {
        IBIZSample0019 domain = ibizSample0019DtoMapping.toDomain(dto);
        ibizSample0019Service.create(domain);
        IBIZSample0019 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0019DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"部门" },  notes = "IBIZSample0019-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0019-Get-all') or hasPermission(this.ibizSample0019DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0019-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0019s/{ibizsample0019Id}")
    public ResponseEntity<IBIZSample0019DTO> getByIbizsample0019Id
            (@PathVariable("ibizsample0019Id") String ibizsample0019Id) {
        IBIZSample0019 rt = ibizSample0019Service.get(ibizsample0019Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0019DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"部门" },  notes = "IBIZSample0019-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0019-Remove-all') or hasPermission(this.ibizSample0019Service.get(#ibizsample0019Id),'DemoSys-IBIZSample0019-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0019s/{ibizsample0019Id}")
    public ResponseEntity<Boolean> removeByIbizsample0019Id
            (@PathVariable("ibizsample0019Id") String ibizsample0019Id) {
        Boolean rt = ibizSample0019Service.remove(ibizsample0019Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"部门" },  notes = "IBIZSample0019-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0019-Update-all') or hasPermission(this.ibizSample0019Service.get(#ibizsample0019Id),'DemoSys-IBIZSample0019-Update')")
    @VersionCheck(entity = "ibizsample0019" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0019s/{ibizsample0019Id}")
    public ResponseEntity<IBIZSample0019DTO> updateByIbizsample0019Id
            (@PathVariable("ibizsample0019Id") String ibizsample0019Id, @Validated @RequestBody IBIZSample0019DTO dto) {
        IBIZSample0019 domain = ibizSample0019DtoMapping.toDomain(dto);
        domain.setIbizsample0019Id(ibizsample0019Id);
        ibizSample0019Service.update(domain);
        IBIZSample0019 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0019DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"部门" },  notes = "IBIZSample0019-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0019s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0019DTO dto) {
        IBIZSample0019 domain = ibizSample0019DtoMapping.toDomain(dto);
        Integer rt = ibizSample0019Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"部门" },  notes = "IBIZSample0019-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0019s/getdraft")
    public ResponseEntity<IBIZSample0019DTO> getDraft
            (IBIZSample0019DTO dto) {
        IBIZSample0019 domain = ibizSample0019DtoMapping.toDomain(dto);
        IBIZSample0019 rt = ibizSample0019Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0019DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"部门" },  notes = "IBIZSample0019-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0019-Save-all') or hasPermission(this.ibizSample0019DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0019-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0019s/save")
    public ResponseEntity<IBIZSample0019DTO> save
            (@Validated @RequestBody IBIZSample0019DTO dto) {
        IBIZSample0019 domain = ibizSample0019DtoMapping.toDomain(dto);
        ibizSample0019Service.save(domain);
        IBIZSample0019 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0019DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"部门" },  notes = "IBIZSample0019-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0019-searchDefault-all','DemoSys-IBIZSample0019-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0019-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0019s/fetchdefault")
    public ResponseEntity<List<IBIZSample0019DTO>> fetchDefault
            (IBIZSample0019SearchContext dto) {
        Page<IBIZSample0019> domains = ibizSample0019Service.searchDefault(dto) ;
        List<IBIZSample0019DTO> list = ibizSample0019DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0019-Create-all')")
    @ApiOperation(value = "批量新建部门", tags = {"部门" },  notes = "批量新建部门")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0019s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0019DTO> dtos) {
        ibizSample0019Service.createBatch(ibizSample0019DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0019-Update-all')")
    @ApiOperation(value = "批量更新部门", tags = {"部门" },  notes = "批量更新部门")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0019s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0019DTO> dtos) {
        ibizSample0019Service.updateBatch(ibizSample0019DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0019-Save-all')")
    @ApiOperation(value = "批量保存部门", tags = {"部门" },  notes = "批量保存部门")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0019s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0019DTO> dtos) {
        ibizSample0019Service.saveBatch(ibizSample0019DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0019-Save-all')")
    @ApiOperation(value = "批量导入部门", tags = {"部门" },  notes = "批量导入部门")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0019s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0019DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0019> list=ibizSample0019DtoMapping.toDomain(dtos);
            List<IBIZSample0019> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0019Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0019-Remove-all')")
    @ApiOperation(value = "批量删除部门", tags = {"部门" },  notes = "批量删除部门")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0019s","/ibizsample0019s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0019Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
