package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.MicroComponent;
import cn.ibizlab.core.sample.filter.MicroComponentSearchContext;

public interface MicroComponentService extends IService<MicroComponent> {

    default MicroComponentService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    MicroComponent get(MicroComponent et);
    default MicroComponent get(String key) {
        MicroComponent et = new MicroComponent();
        et.setMicroComponentId(key);
        return getSelf().get(et);
    }
    default List<MicroComponent> getByIds(Collection<String> ids) {
        List<MicroComponent> entities =new ArrayList();
        ids.forEach(key -> {
            MicroComponent et = new MicroComponent();
            et.setMicroComponentId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<MicroComponent> getByEntities(List<MicroComponent> entities);

    MicroComponent getDraft(MicroComponent et);

    Integer checkKey(MicroComponent et);

    boolean create(MicroComponent et);
    boolean createBatch(List<MicroComponent> list);

    boolean update(MicroComponent et);
    boolean updateBatch(List<MicroComponent> list);

    boolean save(MicroComponent et);
    boolean saveBatch(List<MicroComponent> list);

    default boolean remove(String key) {
        MicroComponent et = new MicroComponent();
        et.setMicroComponentId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(MicroComponent et);

    default boolean removeBatch(Collection<String> ids) {
        List<MicroComponent> entities =new ArrayList();
        ids.forEach(key -> {
            MicroComponent et = new MicroComponent();
            et.setMicroComponentId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<MicroComponent> entities);

    Page<MicroComponent> searchDefault(MicroComponentSearchContext context);
    List<MicroComponent> listDefault(MicroComponentSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}